/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.main.weather;

import com.dooji.electricity.main.weather.WeatherSnapshot;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.saveddata.SavedData;

public final class GlobalWeatherManager {
    private static final Map<ServerLevel, GlobalWeatherManager> INSTANCES = new ConcurrentHashMap<ServerLevel, GlobalWeatherManager>();
    private static final int ZONE_SIZE_CHUNKS = 6;
    private static final int TICKS_PER_STEP = 20;
    private static final int SAVE_INTERVAL = 200;
    private static final int PRUNE_INTERVAL = 400;
    private static final long PRUNE_AGE_TICKS = 24000L;
    private static final long ACTIVE_AGE_TICKS = 2400L;
    private static final double WIND_MIN = 0.2;
    private static final double WIND_MAX = 18.0;
    private final ServerLevel level;
    private final Map<Long, WeatherCell> cells = new ConcurrentHashMap<Long, WeatherCell>();
    private int tickCounter = 0;
    private final float flowDirectionSeed;
    private float flowDirection;
    private final WeatherSavedData savedData;

    public static GlobalWeatherManager get(ServerLevel level) {
        return INSTANCES.computeIfAbsent(level, GlobalWeatherManager::new);
    }

    public static void clear(ServerLevel level) {
        INSTANCES.remove(level);
    }

    private GlobalWeatherManager(ServerLevel level) {
        this.level = level;
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_() ^ 0x9E3779B97F4A7C15L);
        this.flowDirectionSeed = random.m_188501_() * 360.0f;
        this.savedData = (WeatherSavedData)level.m_8895_().m_164861_(WeatherSavedData::load, WeatherSavedData::new, "electricity_weather");
        this.flowDirection = this.savedData.flowDirection != null ? this.savedData.flowDirection.floatValue() : this.flowDirectionSeed;
        this.restoreSavedCells();
    }

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter % 20 != 0) {
            return;
        }
        this.flowDirection = GlobalWeatherManager.wrapDegrees(this.flowDirection + 0.05f * Mth.m_14031_((float)(((float)this.level.m_46467_() + this.flowDirectionSeed) / 2400.0f)));
        long now = this.level.m_46467_();
        for (WeatherCell cell : this.cells.values()) {
            if (now - cell.lastTouched > 2400L && !this.zoneHasLoadedChunks(cell.zoneX, cell.zoneZ)) continue;
            this.updateCell(cell);
        }
        if (this.tickCounter % 400 == 0) {
            this.pruneInactive();
        }
        if (this.tickCounter % 200 == 0) {
            this.savedData.setFlowDirection(this.flowDirection);
            this.savedData.flushIfDirty();
        }
    }

    public WeatherSnapshot sample(BlockPos pos) {
        WeatherCell cell = this.getCell(pos);
        cell.lastTouched = this.level.m_46467_();
        return new WeatherSnapshot(cell.windSpeed, cell.gustSpeed(), cell.turbulence, cell.direction);
    }

    public Map<Long, WeatherSnapshot> snapshotZones() {
        HashMap<Long, WeatherSnapshot> map = new HashMap<Long, WeatherSnapshot>();
        for (Map.Entry<Long, WeatherCell> entry : this.cells.entrySet()) {
            WeatherCell cell = entry.getValue();
            map.put(entry.getKey(), new WeatherSnapshot(cell.windSpeed, cell.gustSpeed(), cell.turbulence, cell.direction));
        }
        return map;
    }

    private WeatherCell getCell(BlockPos pos) {
        int zoneX = Math.floorDiv(pos.m_123341_() >> 4, 6);
        int zoneZ = Math.floorDiv(pos.m_123343_() >> 4, 6);
        long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
        WeatherCell cell = this.cells.computeIfAbsent(key, unused -> this.createCell(zoneX, zoneZ));
        cell.lastTouched = this.level.m_46467_();
        return cell;
    }

    private WeatherCell createCell(int zoneX, int zoneZ) {
        long seed = this.mixSeed(zoneX, zoneZ);
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        float direction = random.m_188501_() * 360.0f;
        double baseWind = 3.0 + random.m_188500_() * 4.0;
        double turbulence = 0.05 + random.m_188500_() * 0.05;
        double phase = random.m_188500_() * Math.PI * 2.0;
        double stormIntensity = 0.15 + random.m_188500_() * 0.1;
        double moistureStore = 0.2 + random.m_188500_() * 0.1;
        WeatherSavedData.CellData data = this.savedData.get(zoneX, zoneZ);
        if (data != null) {
            WeatherCell restored = new WeatherCell(seed, zoneX, zoneZ, (float)data.direction(), data.windSpeed(), data.turbulence(), data.phase(), data.stormIntensity(), data.moistureStore());
            restored.targetWindSpeed = data.targetWindSpeed();
            restored.lastTouched = this.level.m_46467_();
            return restored;
        }
        WeatherCell created = new WeatherCell(seed, zoneX, zoneZ, direction, baseWind, turbulence, phase, stormIntensity, moistureStore);
        created.lastTouched = this.level.m_46467_();
        return created;
    }

    private void updateCell(WeatherCell cell) {
        BlockPos center = new BlockPos((Vec3i)this.getZoneCenter(cell.zoneX, cell.zoneZ));
        double rainForcing = this.samplePrecipitation(center);
        boolean thunder = this.level.m_46470_() && rainForcing > 0.25;
        int surfaceY = center.m_123342_();
        if (this.level.m_7726_().m_5563_(center.m_123341_() >> 4, center.m_123343_() >> 4)) {
            surfaceY = this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, center.m_123341_(), center.m_123343_());
        }
        BlockPos tempPos = new BlockPos(center.m_123341_(), surfaceY, center.m_123343_());
        Holder biomeHolder = this.level.m_204166_(tempPos);
        Biome.ClimateSettings climate = ((Biome)biomeHolder.m_203334_()).getModifiedClimateSettings();
        float temperature = climate.f_47682_().m_8117_(tempPos, climate.f_47681_());
        double coldBias = Mth.m_14008_((double)(1.0 - (double)temperature), (double)0.0, (double)1.5);
        double heatBias = Mth.m_14008_((double)((double)temperature - 1.1), (double)0.0, (double)1.0);
        double moistureInput = 0.08 + rainForcing * 0.55 + (thunder ? 0.3 : 0.0) + coldBias * 0.12 - heatBias * 0.1;
        moistureInput = Mth.m_14008_((double)moistureInput, (double)0.0, (double)1.0);
        double upstream = this.sampleUpstreamStorm(cell);
        double neighborBlend = this.sampleNeighborStorm(cell);
        double time = this.level.m_46467_() + cell.seed;
        double synoptic = 0.5 + 0.5 * Math.sin(time / 3600.0 + cell.phase);
        double pulse = 0.5 + 0.5 * Math.sin(time / 2000.0 + cell.phase * 0.7);
        double growth = moistureInput * (0.35 + synoptic * 0.4) + upstream * 0.35 + neighborBlend * 0.2 + pulse * 0.05;
        double decay = 0.015 + heatBias * 0.01 + cell.stormIntensity * 0.02;
        cell.moistureStore = Mth.m_14008_((double)Mth.m_14139_((double)0.5, (double)cell.moistureStore, (double)moistureInput), (double)0.0, (double)1.0);
        double stormTarget = Mth.m_14008_((double)(cell.stormIntensity + growth - decay), (double)0.0, (double)1.0);
        cell.stormIntensity = Mth.m_14139_((double)0.35, (double)cell.stormIntensity, (double)stormTarget);
        double calmFloor = 2.0 + coldBias * 0.8 - heatBias * 0.6;
        double convective = 10.0 * cell.stormIntensity;
        double baseMax = 6.5 + convective + rainForcing * 3.0;
        if (thunder) {
            baseMax += 4.5 * cell.stormIntensity;
        }
        double shaping = Mth.m_14008_((double)(0.55 + 0.35 * synoptic + 0.1 * pulse), (double)0.0, (double)1.0);
        double target = calmFloor + (baseMax - calmFloor) * shaping;
        target = Mth.m_14008_((double)target, (double)0.2, (double)18.0);
        double blendedTarget = Mth.m_14139_((double)0.25, (double)target, (double)this.sampleNeighborWind(cell, target));
        cell.targetWindSpeed = Mth.m_14139_((double)0.2, (double)cell.targetWindSpeed, (double)blendedTarget);
        cell.windSpeed = Mth.m_14139_((double)0.18, (double)cell.windSpeed, (double)cell.targetWindSpeed);
        double windBias = Mth.m_14008_((double)(cell.windSpeed / 18.0), (double)0.0, (double)1.0);
        double turbulenceTarget = Mth.m_14008_((double)(0.07 + windBias * 0.18 + cell.stormIntensity * 0.35 + rainForcing * 0.15 + (thunder ? 0.08 * cell.stormIntensity : 0.0)), (double)0.03, (double)1.0);
        cell.turbulence = Mth.m_14139_((double)0.3, (double)cell.turbulence, (double)turbulenceTarget);
        float flowTarget = this.flowHeading(cell.zoneX, cell.zoneZ, time);
        cell.direction = this.lerpAngle(cell.direction, flowTarget, 0.18f);
        this.savedData.update(cell.zoneX, cell.zoneZ, cell.windSpeed, cell.targetWindSpeed, cell.turbulence, cell.direction, cell.stormIntensity, cell.moistureStore, cell.phase);
    }

    private double samplePrecipitation(BlockPos center) {
        int[][] offsets;
        int samples = 0;
        int raining = 0;
        int radius = 48;
        for (int[] offset : offsets = new int[][]{{-radius, -radius}, {radius, -radius}, {-radius, radius}, {radius, radius}}) {
            int x = center.m_123341_() + offset[0];
            int z = center.m_123343_() + offset[1];
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (!this.level.m_7726_().m_5563_(chunkX, chunkZ)) continue;
            int y = this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
            BlockPos pos = new BlockPos(x, y, z);
            ++samples;
            if (!this.level.m_46758_(pos)) continue;
            ++raining;
        }
        if (samples == 0) {
            return 0.0;
        }
        return (double)raining / (double)samples;
    }

    private BlockPos getZoneCenter(int zoneX, int zoneZ) {
        int blockX = zoneX * 6 * 16 + 48;
        int blockZ = zoneZ * 6 * 16 + 48;
        return new BlockPos(blockX, 64, blockZ);
    }

    private double sampleNeighborWind(WeatherCell cell, double target) {
        double total = target;
        int count = 1;
        int zoneX = cell.zoneX;
        int zoneZ = cell.zoneZ;
        total += this.neighborWind(zoneX + 1, zoneZ);
        total += this.neighborWind(zoneX - 1, zoneZ);
        total += this.neighborWind(zoneX, zoneZ + 1);
        return (total += this.neighborWind(zoneX, zoneZ - 1)) / (double)(count += 4);
    }

    private double neighborWind(int zoneX, int zoneZ) {
        long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
        WeatherCell cell = this.cells.get(key);
        if (cell != null) {
            return cell.windSpeed;
        }
        return this.targetForCoordinates(zoneX, zoneZ);
    }

    private double sampleNeighborStorm(WeatherCell cell) {
        double total = 0.0;
        int count = 0;
        int zoneX = cell.zoneX;
        int zoneZ = cell.zoneZ;
        total += this.neighborStorm(zoneX + 1, zoneZ);
        total += this.neighborStorm(zoneX - 1, zoneZ);
        total += this.neighborStorm(zoneX, zoneZ + 1);
        return (count += 4) == 0 ? 0.0 : (total += this.neighborStorm(zoneX, zoneZ - 1)) / (double)count;
    }

    private double neighborStorm(int zoneX, int zoneZ) {
        long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
        WeatherCell cell = this.cells.get(key);
        if (cell != null) {
            return cell.stormIntensity;
        }
        return 0.0;
    }

    private double sampleUpstreamStorm(WeatherCell cell) {
        int upstreamZ;
        int upstreamX;
        long key;
        WeatherCell upstream;
        double radians = Math.toRadians(this.flowHeading(cell.zoneX, cell.zoneZ, this.level.m_46467_() + cell.seed));
        int stepX = (int)Math.signum(Math.cos(radians));
        int stepZ = (int)Math.signum(Math.sin(radians));
        if (stepX == 0 && stepZ == 0) {
            stepX = 1;
        }
        if ((upstream = this.cells.get(key = (long)(upstreamX = cell.zoneX - stepX) << 32 ^ (long)(upstreamZ = cell.zoneZ - stepZ) & 0xFFFFFFFFL)) != null) {
            return upstream.stormIntensity;
        }
        return 0.1;
    }

    private double targetForCoordinates(int zoneX, int zoneZ) {
        long seed = this.mixSeed(zoneX, zoneZ);
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        return 2.5 + random.m_188500_() * 4.0;
    }

    private long mixSeed(int zoneX, int zoneZ) {
        long seed = this.level.m_7328_();
        return seed ^ (long)zoneX * 341873128712L ^ (long)zoneZ * 132897987541L;
    }

    private static float wrapDegrees(float degrees) {
        float wrapped = degrees % 360.0f;
        if (wrapped < 0.0f) {
            wrapped += 360.0f;
        }
        return wrapped;
    }

    private float lerpAngle(float current, float target, float alpha) {
        float delta = GlobalWeatherManager.wrapDegrees(target - current);
        if (delta > 180.0f) {
            delta -= 360.0f;
        }
        return GlobalWeatherManager.wrapDegrees(current + delta * alpha);
    }

    private static double angularDelta(double a, double b) {
        double delta = a - b;
        delta = (delta + 540.0) % 360.0 - 180.0;
        return delta;
    }

    private float flowHeading(int zoneX, int zoneZ, double time) {
        double base = (double)this.flowDirection + Math.sin((double)zoneX * 0.12 + time / 3200.0) * 18.0 + Math.cos((double)zoneZ * 0.1 + time / 2800.0) * 14.0;
        double neighborX = (double)this.flowDirection + Math.sin((double)(zoneX + 1) * 0.12 + time / 3200.0) * 18.0 + Math.cos((double)zoneZ * 0.1 + time / 2800.0) * 14.0;
        double neighborZ = (double)this.flowDirection + Math.sin((double)zoneX * 0.12 + time / 3200.0) * 18.0 + Math.cos((double)(zoneZ + 1) * 0.1 + time / 2800.0) * 14.0;
        double avg = (base + neighborX + neighborZ) / 3.0;
        return GlobalWeatherManager.wrapDegrees((float)((double)this.flowDirectionSeed + avg));
    }

    private boolean zoneHasLoadedChunks(int zoneX, int zoneZ) {
        int startChunkX = zoneX * 6;
        int startChunkZ = zoneZ * 6;
        int endChunkX = startChunkX + 6 - 1;
        int endChunkZ = startChunkZ + 6 - 1;
        for (int chunkX = startChunkX; chunkX <= endChunkX; ++chunkX) {
            for (int chunkZ = startChunkZ; chunkZ <= endChunkZ; ++chunkZ) {
                if (!this.level.m_7726_().m_5563_(chunkX, chunkZ)) continue;
                return true;
            }
        }
        return false;
    }

    private void pruneInactive() {
        long now = this.level.m_46467_();
        this.cells.entrySet().removeIf(entry -> {
            WeatherCell cell = (WeatherCell)entry.getValue();
            if (now - cell.lastTouched < 24000L) {
                return false;
            }
            int startChunkX = cell.zoneX * 6;
            int startChunkZ = cell.zoneZ * 6;
            int endChunkX = startChunkX + 6 - 1;
            int endChunkZ = startChunkZ + 6 - 1;
            for (int chunkX = startChunkX; chunkX <= endChunkX; ++chunkX) {
                for (int chunkZ = startChunkZ; chunkZ <= endChunkZ; ++chunkZ) {
                    if (!this.level.m_7726_().m_5563_(chunkX, chunkZ)) continue;
                    return false;
                }
            }
            this.savedData.remove(cell.zoneX, cell.zoneZ);
            return true;
        });
    }

    private void restoreSavedCells() {
        for (WeatherSavedData.CellData data : this.savedData.all()) {
            long key = (long)data.zoneX() << 32 ^ (long)data.zoneZ() & 0xFFFFFFFFL;
            double windSpeed = data.windSpeed();
            double targetWindSpeed = data.targetWindSpeed();
            double turbulence = data.turbulence();
            float direction = (float)data.direction();
            double stormIntensity = data.stormIntensity();
            double moistureStore = data.moistureStore();
            double phase = data.phase();
            WeatherCell cell = new WeatherCell(this.mixSeed(data.zoneX(), data.zoneZ()), data.zoneX(), data.zoneZ(), direction, windSpeed, turbulence, phase, stormIntensity, moistureStore);
            cell.targetWindSpeed = targetWindSpeed;
            cell.lastTouched = this.level.m_46467_();
            this.cells.put(key, cell);
        }
    }

    private static final class WeatherSavedData
    extends SavedData {
        private final Map<Long, CellData> cells = new ConcurrentHashMap<Long, CellData>();
        private Double flowDirection;
        private boolean dirtyFlag = false;

        private WeatherSavedData() {
        }

        private static WeatherSavedData load(CompoundTag tag) {
            WeatherSavedData data = new WeatherSavedData();
            data.read(tag);
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            ListTag list = new ListTag();
            for (CellData cell : this.cells.values()) {
                CompoundTag entry = new CompoundTag();
                entry.m_128405_("zoneX", cell.zoneX());
                entry.m_128405_("zoneZ", cell.zoneZ());
                entry.m_128347_("windSpeed", cell.windSpeed());
                entry.m_128347_("targetWindSpeed", cell.targetWindSpeed());
                entry.m_128347_("turbulence", cell.turbulence());
                entry.m_128347_("direction", cell.direction());
                entry.m_128347_("stormIntensity", cell.stormIntensity());
                entry.m_128347_("moistureStore", cell.moistureStore());
                entry.m_128347_("phase", cell.phase());
                list.add((Object)entry);
            }
            tag.m_128365_("cells", (Tag)list);
            if (this.flowDirection != null) {
                tag.m_128347_("flowDirection", this.flowDirection.doubleValue());
            }
            return tag;
        }

        private void read(CompoundTag tag) {
            this.cells.clear();
            ListTag list = tag.m_128437_("cells", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                int zoneX = entry.m_128451_("zoneX");
                int zoneZ = entry.m_128451_("zoneZ");
                double windSpeed = entry.m_128459_("windSpeed");
                double targetWindSpeed = entry.m_128459_("targetWindSpeed");
                double turbulence = entry.m_128459_("turbulence");
                double direction = entry.m_128459_("direction");
                double stormIntensity = entry.m_128459_("stormIntensity");
                double moistureStore = entry.m_128459_("moistureStore");
                double phase = entry.m_128459_("phase");
                long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
                this.cells.put(key, new CellData(zoneX, zoneZ, windSpeed, targetWindSpeed, turbulence, direction, stormIntensity, moistureStore, phase));
            }
            if (tag.m_128441_("flowDirection")) {
                this.flowDirection = tag.m_128459_("flowDirection");
            }
        }

        private void update(int zoneX, int zoneZ, double windSpeed, double targetWindSpeed, double turbulence, double direction, double stormIntensity, double moistureStore, double phase) {
            long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
            CellData existing = this.cells.get(key);
            if (existing != null) {
                double dirDelta = GlobalWeatherManager.angularDelta(existing.direction, direction);
                if (Math.abs(existing.windSpeed - windSpeed) < 0.01 && Math.abs(existing.targetWindSpeed - targetWindSpeed) < 0.01 && Math.abs(existing.turbulence - turbulence) < 0.005 && Math.abs(dirDelta) < 0.5 && Math.abs(existing.stormIntensity - stormIntensity) < 0.01 && Math.abs(existing.moistureStore - moistureStore) < 0.01) {
                    return;
                }
            }
            this.cells.put(key, new CellData(zoneX, zoneZ, windSpeed, targetWindSpeed, turbulence, direction, stormIntensity, moistureStore, phase));
            this.dirtyFlag = true;
        }

        private CellData get(int zoneX, int zoneZ) {
            long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
            return this.cells.get(key);
        }

        private Iterable<CellData> all() {
            return this.cells.values();
        }

        void setFlowDirection(float flowDirection) {
            if (this.flowDirection != null && Math.abs(GlobalWeatherManager.angularDelta(this.flowDirection, flowDirection)) < 0.5) {
                return;
            }
            this.flowDirection = flowDirection;
            this.dirtyFlag = true;
        }

        void flushIfDirty() {
            if (this.dirtyFlag) {
                this.m_77762_();
                this.dirtyFlag = false;
            }
        }

        void remove(int zoneX, int zoneZ) {
            long key = (long)zoneX << 32 ^ (long)zoneZ & 0xFFFFFFFFL;
            if (this.cells.remove(key) != null) {
                this.dirtyFlag = true;
            }
        }

        private record CellData(int zoneX, int zoneZ, double windSpeed, double targetWindSpeed, double turbulence, double direction, double stormIntensity, double moistureStore, double phase) {
        }
    }

    private static final class WeatherCell {
        double windSpeed;
        double targetWindSpeed;
        double turbulence;
        float direction;
        double stormIntensity;
        double moistureStore;
        long lastTouched;
        final long seed;
        final int zoneX;
        final int zoneZ;
        final double phase;

        WeatherCell(long seed, int zoneX, int zoneZ, float direction, double windSpeed, double turbulence, double phase, double stormIntensity, double moistureStore) {
            this.seed = seed;
            this.zoneX = zoneX;
            this.zoneZ = zoneZ;
            this.direction = direction;
            this.windSpeed = windSpeed;
            this.targetWindSpeed = windSpeed;
            this.turbulence = turbulence;
            this.phase = phase;
            this.stormIntensity = stormIntensity;
            this.moistureStore = moistureStore;
            this.lastTouched = 0L;
        }

        double gustSpeed() {
            double gustFactor = 1.0 + this.turbulence * 0.9;
            return this.windSpeed * gustFactor;
        }
    }
}

