/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.main.wire;

import net.minecraft.core.BlockPos;

public class WireConnection {
    private final int startInsulatorId;
    private final int endInsulatorId;
    private final String wireType;
    private final BlockPos startBlockPos;
    private final BlockPos endBlockPos;
    private final String startBlockType;
    private final String endBlockType;
    private final String startPowerType;
    private final String endPowerType;

    public WireConnection(int startInsulatorId, int endInsulatorId) {
        this(startInsulatorId, endInsulatorId, "default", BlockPos.f_121853_, BlockPos.f_121853_, "unknown", "unknown", "unknown", "unknown");
    }

    public WireConnection(int startInsulatorId, int endInsulatorId, String wireType) {
        this(startInsulatorId, endInsulatorId, wireType, BlockPos.f_121853_, BlockPos.f_121853_, "unknown", "unknown", "unknown", "unknown");
    }

    public WireConnection(int startInsulatorId, int endInsulatorId, String wireType, BlockPos startBlockPos, BlockPos endBlockPos, String startBlockType, String endBlockType) {
        this(startInsulatorId, endInsulatorId, wireType, startBlockPos, endBlockPos, startBlockType, endBlockType, "unknown", "unknown");
    }

    public WireConnection(int startInsulatorId, int endInsulatorId, String wireType, BlockPos startBlockPos, BlockPos endBlockPos, String startBlockType, String endBlockType, String startPowerType, String endPowerType) {
        this.startInsulatorId = startInsulatorId;
        this.endInsulatorId = endInsulatorId;
        this.wireType = wireType;
        this.startBlockPos = startBlockPos;
        this.endBlockPos = endBlockPos;
        this.startBlockType = startBlockType;
        this.endBlockType = endBlockType;
        this.startPowerType = startPowerType;
        this.endPowerType = endPowerType;
    }

    public int getStartInsulatorId() {
        return this.startInsulatorId;
    }

    public int getEndInsulatorId() {
        return this.endInsulatorId;
    }

    public String getWireType() {
        return this.wireType;
    }

    public BlockPos getStartBlockPos() {
        return this.startBlockPos;
    }

    public BlockPos getEndBlockPos() {
        return this.endBlockPos;
    }

    public String getStartBlockType() {
        return this.startBlockType;
    }

    public String getEndBlockType() {
        return this.endBlockType;
    }

    public String getStartPowerType() {
        return this.startPowerType;
    }

    public String getEndPowerType() {
        return this.endPowerType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WireConnection that = (WireConnection)obj;
        return this.startInsulatorId == that.startInsulatorId && this.endInsulatorId == that.endInsulatorId && this.wireType.equals(that.wireType) && this.startBlockPos.equals((Object)that.startBlockPos) && this.endBlockPos.equals((Object)that.endBlockPos);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.startInsulatorId);
        result = 31 * result + Integer.hashCode(this.endInsulatorId);
        result = 31 * result + this.wireType.hashCode();
        result = 31 * result + this.startBlockPos.hashCode();
        result = 31 * result + this.endBlockPos.hashCode();
        return result;
    }

    public String toString() {
        return this.startInsulatorId + " -> " + this.endInsulatorId + " (" + this.wireType + ")";
    }
}

