/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.main.wire;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.main.network.ElectricityNetworking;
import com.dooji.electricity.main.network.payloads.CreateWireFromInsulatorsPayload;
import com.dooji.electricity.main.network.payloads.SyncWiresPayload;
import com.dooji.electricity.main.network.payloads.WireConnectionPayload;
import com.dooji.electricity.main.wire.WireConnection;
import com.dooji.electricity.wire.InsulatorPartHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class WireManager {
    private static final Map<ServerLevel, WireSavedData> SAVED_DATA_CACHE = new ConcurrentHashMap<ServerLevel, WireSavedData>();
    private static final double MAX_WIRE_DISTANCE = 64.0;
    private static final double MAX_WIRE_DISTANCE_SQ = 4096.0;

    public InteractionResult handleWireUse(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(clickedPos);
        if (!(blockEntity instanceof UtilityPoleBlockEntity || blockEntity instanceof ElectricCabinBlockEntity || blockEntity instanceof PowerBoxBlockEntity || blockEntity instanceof WindTurbineBlockEntity)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public void createWireFromInsulators(ServerPlayer player, CreateWireFromInsulatorsPayload payload) {
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_284548_();
        if (!this.validateEndpoint(player, level, payload.startBlockPos()) || !this.validateEndpoint(player, level, payload.endBlockPos())) {
            return;
        }
        BlockEntity startEntity = level.m_7702_(payload.startBlockPos());
        BlockEntity endEntity = level.m_7702_(payload.endBlockPos());
        if (startEntity == null || endEntity == null) {
            return;
        }
        Optional<InsulatorPartHelper.Insulator> startInsulator = InsulatorPartHelper.resolve(startEntity, payload.startInsulatorId());
        Optional<InsulatorPartHelper.Insulator> endInsulator = InsulatorPartHelper.resolve(endEntity, payload.endInsulatorId());
        if (startInsulator.isEmpty() || endInsulator.isEmpty()) {
            this.notifyPlayer(player, (Component)Component.m_237115_((String)"message.electricity.wire.failed_insulator"));
            return;
        }
        if (!InsulatorPartHelper.matchesReportedType(startEntity, payload.startBlockType()) || !InsulatorPartHelper.matchesReportedType(endEntity, payload.endBlockType())) {
            return;
        }
        Vec3 startAnchor = startInsulator.get().anchor();
        Vec3 endAnchor = endInsulator.get().anchor();
        if (startAnchor == null || endAnchor == null) {
            this.notifyPlayer(player, (Component)Component.m_237115_((String)"message.electricity.wire.anchor_unavailable"));
            return;
        }
        double spanDistanceSq = startAnchor.m_82557_(endAnchor);
        if (spanDistanceSq > 4096.0) {
            this.notifyPlayer(player, (Component)Component.m_237110_((String)"message.electricity.wire.too_far", (Object[])new Object[]{String.format("%.1f", Math.sqrt(spanDistanceSq)), 64.0}));
            return;
        }
        String startPowerType = this.sanitizePowerType(startEntity, startInsulator.get().partName(), payload.startPowerType());
        String endPowerType = this.sanitizePowerType(endEntity, endInsulator.get().partName(), payload.endPowerType());
        WireConnection connection = new WireConnection(startInsulator.get().insulatorId(), endInsulator.get().insulatorId(), "default", payload.startBlockPos(), payload.endBlockPos(), startInsulator.get().blockType(), endInsulator.get().blockType(), startPowerType, endPowerType);
        this.saveWireConnection(level, connection);
        this.broadcastWireCreation(level, connection);
        this.notifyPlayer(player, (Component)Component.m_237110_((String)"message.electricity.wire.connected", (Object[])new Object[]{startInsulator.get().insulatorId(), endInsulator.get().insulatorId()}));
    }

    private void saveWireConnection(ServerLevel level, WireConnection connection) {
        WireSavedData savedData = this.getOrCreateSavedData(level);
        savedData.addWireConnection(connection);
        savedData.m_77762_();
    }

    private void broadcastWireCreation(ServerLevel level, WireConnection connection) {
        WireConnectionPayload payload = new WireConnectionPayload(connection, true);
        ElectricityNetworking.broadcastToAllClients(level, payload);
    }

    private boolean validateEndpoint(ServerPlayer player, ServerLevel level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            this.notifyPlayer(player, (Component)Component.m_237110_((String)"message.electricity.wire.chunk_unloaded", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
            return false;
        }
        if (!level.m_6857_().m_61937_(pos)) {
            return false;
        }
        if (!level.m_7966_((Player)player, pos)) {
            this.notifyPlayer(player, (Component)Component.m_237110_((String)"message.electricity.wire.no_permission", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
            return false;
        }
        return true;
    }

    private void notifyPlayer(ServerPlayer player, Component message) {
        if (player != null && message != null) {
            player.m_5661_(message, true);
        }
    }

    private String sanitizePowerType(BlockEntity entity, String partName, String reported) {
        String expected = InsulatorPartHelper.determinePowerType(entity, partName);
        if ("bidirectional".equals(expected)) {
            return "bidirectional";
        }
        if ("output".equals(expected) || "input".equals(expected)) {
            return expected;
        }
        return reported != null ? reported : "bidirectional";
    }

    private void broadcastWireRemoval(ServerLevel level, WireConnection connection) {
        WireConnectionPayload payload = new WireConnectionPayload(connection, false);
        ElectricityNetworking.broadcastToAllClients(level, payload);
    }

    public void sendAllWiresToPlayer(ServerPlayer player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WireSavedData savedData = this.getOrCreateSavedData(serverLevel);
            SyncWiresPayload payload = new SyncWiresPayload(new ArrayList<WireConnection>(savedData.getAllWireConnections()));
            ElectricityNetworking.sendToClient(player, payload);
        }
    }

    public void loadFromWorld(ServerLevel level) {
        WireSavedData savedData = this.getOrCreateSavedData(level);
    }

    public void forceSave(ServerLevel level) {
        WireSavedData savedData = this.getOrCreateSavedData(level);
        savedData.m_77762_();
    }

    public WireSavedData getSavedData(ServerLevel level) {
        return this.getOrCreateSavedData(level);
    }

    public void removeConnectionsForInsulators(ServerLevel level, int[] insulatorIds) {
        if (insulatorIds == null || insulatorIds.length == 0) {
            return;
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (int id : insulatorIds) {
            if (id < 0) continue;
            ids.add(id);
        }
        if (ids.isEmpty()) {
            return;
        }
        WireSavedData savedData = this.getOrCreateSavedData(level);
        List<WireConnection> removedConnections = savedData.removeConnectionsForInsulators(ids);
        if (removedConnections.isEmpty()) {
            return;
        }
        savedData.m_77762_();
        for (WireConnection connection : removedConnections) {
            this.broadcastWireRemoval(level, connection);
        }
    }

    private WireSavedData getOrCreateSavedData(ServerLevel level) {
        return SAVED_DATA_CACHE.computeIfAbsent(level, l -> (WireSavedData)l.m_8895_().m_164861_(WireSavedData::new, WireSavedData::new, "electricity_wires"));
    }

    public static class WireSavedData
    extends SavedData {
        private final Map<String, WireConnection> wireConnections = new ConcurrentHashMap<String, WireConnection>();

        public WireSavedData() {
        }

        public WireSavedData(CompoundTag tag) {
            this.load(tag);
        }

        public void addWireConnection(WireConnection connection) {
            String key = connection.getStartInsulatorId() + "_" + connection.getEndInsulatorId();
            this.wireConnections.put(key, connection);
        }

        public void removeWireConnection(WireConnection connection) {
            String key = connection.getStartInsulatorId() + "_" + connection.getEndInsulatorId();
            this.wireConnections.remove(key);
        }

        public List<WireConnection> removeConnectionsForInsulators(Set<Integer> insulatorIds) {
            ArrayList<WireConnection> removed = new ArrayList<WireConnection>();
            Iterator<WireConnection> iterator = this.wireConnections.values().iterator();
            while (iterator.hasNext()) {
                WireConnection connection = iterator.next();
                if (!insulatorIds.contains(connection.getStartInsulatorId()) && !insulatorIds.contains(connection.getEndInsulatorId())) continue;
                iterator.remove();
                removed.add(connection);
            }
            return removed;
        }

        public Collection<WireConnection> getAllWireConnections() {
            return this.wireConnections.values();
        }

        public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
            ListTag wiresList = new ListTag();
            for (WireConnection connection : this.wireConnections.values()) {
                CompoundTag wireTag = new CompoundTag();
                wireTag.m_128405_("startInsulatorId", connection.getStartInsulatorId());
                wireTag.m_128405_("endInsulatorId", connection.getEndInsulatorId());
                wireTag.m_128359_("wireType", connection.getWireType());
                wireTag.m_128356_("startBlockPos", connection.getStartBlockPos().m_121878_());
                wireTag.m_128356_("endBlockPos", connection.getEndBlockPos().m_121878_());
                wireTag.m_128359_("startBlockType", connection.getStartBlockType());
                wireTag.m_128359_("endBlockType", connection.getEndBlockType());
                wireTag.m_128359_("startPowerType", connection.getStartPowerType());
                wireTag.m_128359_("endPowerType", connection.getEndPowerType());
                wiresList.add((Object)wireTag);
            }
            tag.m_128365_("wires", (Tag)wiresList);
            return tag;
        }

        private void load(CompoundTag tag) {
            this.wireConnections.clear();
            ListTag wiresList = tag.m_128437_("wires", 10);
            for (int i = 0; i < wiresList.size(); ++i) {
                CompoundTag wireTag = wiresList.m_128728_(i);
                int startInsulatorId = wireTag.m_128451_("startInsulatorId");
                int endInsulatorId = wireTag.m_128451_("endInsulatorId");
                String wireType = wireTag.m_128461_("wireType");
                BlockPos startBlockPos = BlockPos.m_122022_((long)wireTag.m_128454_("startBlockPos"));
                BlockPos endBlockPos = BlockPos.m_122022_((long)wireTag.m_128454_("endBlockPos"));
                String startBlockType = wireTag.m_128461_("startBlockType");
                String endBlockType = wireTag.m_128461_("endBlockType");
                String startPowerType = wireTag.m_128461_("startPowerType");
                String endPowerType = wireTag.m_128461_("endPowerType");
                WireConnection connection = new WireConnection(startInsulatorId, endInsulatorId, wireType, startBlockPos, endBlockPos, startBlockType, endBlockType, startPowerType, endPowerType);
                String key = startInsulatorId + "_" + endInsulatorId;
                this.wireConnections.put(key, connection);
            }
        }
    }
}

