/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.wire;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public final class InsulatorPartHelper {
    public static final String TYPE_WIND_TURBINE = "wind_turbine";
    public static final String TYPE_ELECTRIC_CABIN = "electric_cabin";
    public static final String TYPE_UTILITY_POLE = "utility_pole";
    public static final String TYPE_POWER_BOX = "power_box";
    private static final String[] UTILITY_POLE_PARTS = new String[]{"insulator_1_Material.023", "insulator_2_Material.009", "insulator_3_Material.016", "insulator_4_Material.001", "insulator_5_Material.051", "insulator_6_Material.037", "insulator_7_Material.030", "insulator_8_Material.058"};
    private static final String[] ELECTRIC_CABIN_PARTS = new String[]{"insulator_input_Material.065", "insulatoroutput_Material.044"};
    private static final String[] POWER_BOX_PARTS = new String[]{"insulator_Material"};
    private static final String[] WIND_TURBINE_PARTS = new String[]{"insulator_Plastic"};

    private InsulatorPartHelper() {
    }

    public static Optional<Insulator> resolve(BlockEntity entity, String partName) {
        if (entity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)entity;
            return InsulatorPartHelper.mapFromArray(TYPE_UTILITY_POLE, partName, UTILITY_POLE_PARTS, pole.getInsulatorIds(), pole::getWirePosition);
        }
        if (entity instanceof ElectricCabinBlockEntity) {
            ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)entity;
            return InsulatorPartHelper.mapFromArray(TYPE_ELECTRIC_CABIN, partName, ELECTRIC_CABIN_PARTS, cabin.getInsulatorIds(), cabin::getWirePosition);
        }
        if (entity instanceof PowerBoxBlockEntity) {
            PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)entity;
            return InsulatorPartHelper.mapFromArray(TYPE_POWER_BOX, partName, POWER_BOX_PARTS, powerBox.getInsulatorIds(), powerBox::getWirePosition);
        }
        if (entity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)entity;
            return InsulatorPartHelper.mapFromArray(TYPE_WIND_TURBINE, partName, WIND_TURBINE_PARTS, turbine.getInsulatorIds(), turbine::getWirePosition);
        }
        return Optional.empty();
    }

    public static Optional<Insulator> resolve(BlockEntity entity, int insulatorId) {
        if (entity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)entity;
            return InsulatorPartHelper.mapFromId(TYPE_UTILITY_POLE, insulatorId, UTILITY_POLE_PARTS, pole.getInsulatorIds(), pole::getWirePosition);
        }
        if (entity instanceof ElectricCabinBlockEntity) {
            ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)entity;
            return InsulatorPartHelper.mapFromId(TYPE_ELECTRIC_CABIN, insulatorId, ELECTRIC_CABIN_PARTS, cabin.getInsulatorIds(), cabin::getWirePosition);
        }
        if (entity instanceof PowerBoxBlockEntity) {
            PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)entity;
            return InsulatorPartHelper.mapFromId(TYPE_POWER_BOX, insulatorId, POWER_BOX_PARTS, powerBox.getInsulatorIds(), powerBox::getWirePosition);
        }
        if (entity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)entity;
            return InsulatorPartHelper.mapFromId(TYPE_WIND_TURBINE, insulatorId, WIND_TURBINE_PARTS, turbine.getInsulatorIds(), turbine::getWirePosition);
        }
        return Optional.empty();
    }

    private static Optional<Insulator> mapFromArray(String blockType, String partName, String[] parts, int[] insulatorIds, PositionResolver resolver) {
        if (partName == null) {
            return Optional.empty();
        }
        int index = InsulatorPartHelper.indexOf(parts, partName);
        if (index < 0 || index >= insulatorIds.length) {
            return Optional.empty();
        }
        int insulatorId = insulatorIds[index];
        return Optional.of(new Insulator(blockType, insulatorId, index, parts[index], resolver.resolve(index)));
    }

    private static Optional<Insulator> mapFromId(String blockType, int targetId, String[] partNames, int[] insulatorIds, PositionResolver resolver) {
        for (int i = 0; i < insulatorIds.length; ++i) {
            if (insulatorIds[i] != targetId || targetId < 0) continue;
            Vec3 anchor = resolver.resolve(i);
            String partName = partNames != null && i < partNames.length ? partNames[i] : null;
            return Optional.of(new Insulator(blockType, targetId, i, partName, anchor));
        }
        return Optional.empty();
    }

    private static int indexOf(String[] parts, String partName) {
        for (int i = 0; i < parts.length; ++i) {
            if (!Objects.equals(parts[i], partName)) continue;
            return i;
        }
        return -1;
    }

    public static String determinePowerType(BlockEntity entity, String partName) {
        if (entity instanceof WindTurbineBlockEntity) {
            return "output";
        }
        if (entity instanceof ElectricCabinBlockEntity) {
            if (partName != null && partName.toLowerCase(Locale.ROOT).contains("output")) {
                return "output";
            }
            if (partName != null && partName.toLowerCase(Locale.ROOT).contains("input")) {
                return "input";
            }
        }
        return "bidirectional";
    }

    public static String getBlockType(BlockEntity entity) {
        if (entity instanceof WindTurbineBlockEntity) {
            return TYPE_WIND_TURBINE;
        }
        if (entity instanceof ElectricCabinBlockEntity) {
            return TYPE_ELECTRIC_CABIN;
        }
        if (entity instanceof UtilityPoleBlockEntity) {
            return TYPE_UTILITY_POLE;
        }
        if (entity instanceof PowerBoxBlockEntity) {
            return TYPE_POWER_BOX;
        }
        return "unknown";
    }

    public static boolean matchesReportedType(BlockEntity entity, String reportedType) {
        return Objects.equals(InsulatorPartHelper.getBlockType(entity), reportedType);
    }

    public static String[] cabinPartNames() {
        return Arrays.copyOf(ELECTRIC_CABIN_PARTS, ELECTRIC_CABIN_PARTS.length);
    }

    public static String[] polePartNames() {
        return Arrays.copyOf(UTILITY_POLE_PARTS, UTILITY_POLE_PARTS.length);
    }

    public static String[] powerBoxPartNames() {
        return Arrays.copyOf(POWER_BOX_PARTS, POWER_BOX_PARTS.length);
    }

    public static String[] turbinePartNames() {
        return Arrays.copyOf(WIND_TURBINE_PARTS, WIND_TURBINE_PARTS.length);
    }

    @FunctionalInterface
    private static interface PositionResolver {
        public Vec3 resolve(int var1);
    }

    public record Insulator(String blockType, int insulatorId, int index, String partName, Vec3 anchor) {
    }
}

