/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.obj;

import de.javagl.obj.FloatTuple;
import java.util.Arrays;

final class DefaultFloatTuple
implements FloatTuple {
    private final float[] values;

    DefaultFloatTuple(float[] values) {
        this.values = values;
    }

    DefaultFloatTuple(float x, float y, float z, float w) {
        this(new float[]{x, y, z, w});
    }

    DefaultFloatTuple(float x, float y, float z) {
        this(new float[]{x, y, z});
    }

    DefaultFloatTuple(float x, float y) {
        this(new float[]{x, y});
    }

    DefaultFloatTuple(float x) {
        this(new float[]{x});
    }

    DefaultFloatTuple(FloatTuple other) {
        this(DefaultFloatTuple.getValues(other));
    }

    private static float[] getValues(FloatTuple f) {
        if (f instanceof DefaultFloatTuple) {
            DefaultFloatTuple other = (DefaultFloatTuple)f;
            return (float[])other.values.clone();
        }
        float[] values = new float[f.getDimensions()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = f.get(i);
        }
        return values;
    }

    @Override
    public float get(int index) {
        return this.values[index];
    }

    @Override
    public float getX() {
        return this.values[0];
    }

    void setX(float x) {
        this.values[0] = x;
    }

    @Override
    public float getY() {
        return this.values[1];
    }

    void setY(float y) {
        this.values[1] = y;
    }

    @Override
    public float getZ() {
        return this.values[2];
    }

    void setZ(float z) {
        this.values[2] = z;
    }

    @Override
    public float getW() {
        return this.values[3];
    }

    void setW(float w) {
        this.values[3] = w;
    }

    @Override
    public int getDimensions() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.getDimensions(); ++i) {
            sb.append(this.get(i));
            if (i >= this.getDimensions() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof DefaultFloatTuple) {
            DefaultFloatTuple other = (DefaultFloatTuple)object;
            return Arrays.equals(this.values, other.values);
        }
        if (object instanceof FloatTuple) {
            FloatTuple other = (FloatTuple)object;
            if (other.getDimensions() != this.getDimensions()) {
                return false;
            }
            for (int i = 0; i < this.getDimensions(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

