/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.mixin.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_312.class})
public class MouseMixin {
    @Unique
    private long lastScrollTime = 0L;
    @Unique
    private static final long SCROLL_DELAY_MS = 30L;

    @Inject(method={"onMouseScroll"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScroll(long window, double horizontal, double vertical, CallbackInfo ci) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastScrollTime < 30L) {
            ci.cancel();
            return;
        }
        this.lastScrollTime = currentTime;
    }
}

