/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.common;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ModLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation DEFAULT_TREASURE_CHEST_LOOT = ModLootTables.register("treasures_of_the_dead:gameplay/open_treasure");
    public static final ResourceLocation SKULL_MERCHANT_SHOP = ModLootTables.register("treasures_of_the_dead:chests/skull_merchant_shop/skull_merchant_shop");

    private static ResourceLocation register(String pId) {
        return ModLootTables.register(new ResourceLocation(pId));
    }

    private static ResourceLocation register(ResourceLocation pId) {
        if (LOCATIONS.add(pId)) {
            return pId;
        }
        throw new IllegalArgumentException(pId + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

