/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BloomingSkeletonInterface;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.BloomingSkeletonVariant;
import org.jetbrains.annotations.Nullable;

public class BloomingSkeletonEntity
extends TOTDSkeletonEntity
implements BloomingSkeletonInterface {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(BloomingSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BloomingSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void specialProcedures() {
        BloomingSkeletonVariant variant = (BloomingSkeletonVariant)((Object)Util.m_214670_((Object[])BloomingSkeletonVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.f_19796_);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, (double)0.24f).m_22265_();
    }

    @Override
    public int getTickCount() {
        return this.f_19797_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20070_()) {
            this.CreateBloomingParticles(this.m_9236_(), this.f_19796_, this.m_20182_());
            if (this.f_19797_ % 10 == 0) {
                this.m_5634_(2.0f);
            }
        } else if (this.f_19797_ % 10 == 0) {
            this.m_5634_(0.5f);
        }
    }

    public void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        if (this.getBloomingVariant().equals((Object)BloomingSkeletonVariant.VAR2) || this.getBloomingVariant().equals((Object)BloomingSkeletonVariant.VAR3)) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41852_));
        }
        if (this.getBloomingVariant().equals((Object)BloomingSkeletonVariant.VAR4) || this.getBloomingVariant().equals((Object)BloomingSkeletonVariant.VAR5)) {
            this.spawnRandomBandanas(this.f_19796_);
        }
    }

    public BloomingSkeletonVariant getBloomingVariant() {
        return BloomingSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(BloomingSkeletonVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }
}

