/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonInterface;
import net.mrwilfis.treasures_of_the_dead.entity.custom.GoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainGoldenSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class CaptainGoldenSkeletonEntity
extends GoldenSkeletonEntity
implements CaptainSkeletonInterface {
    private static final EntityDataAccessor<Float> DEATH_X = SynchedEntityData.m_135353_(CaptainGoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DEATH_Z = SynchedEntityData.m_135353_(CaptainGoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> CAN_DROP_KEYS_AND_ORDERS = SynchedEntityData.m_135353_(CaptainGoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(CaptainGoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CaptainGoldenSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void specialProcedures() {
        CaptainGoldenSkeletonVariant variant = (CaptainGoldenSkeletonVariant)((Object)Util.m_214670_((Object[])CaptainGoldenSkeletonVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.f_19796_);
        this.m_6593_((Component)Component.m_237113_((String)this.getRandomName(this.f_19796_)));
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, (double)0.65f).m_22268_(Attributes.f_22279_, (double)0.18f).m_22265_();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.getCanDropKeysAndOrders()) {
            double randomValue = this.f_19796_.m_188501_();
            if (randomValue < (double)0.4f) {
                this.setDeathX((float)this.m_20185_());
                this.setDeathZ((float)this.m_20189_());
                ItemStack stack = new ItemStack((ItemLike)ModItems.SKELETONS_ORDER.get());
                stack.m_41751_(new CompoundTag());
                stack.m_41783_().m_128350_("DeathX", this.getDeathX());
                stack.m_41783_().m_128350_("DeathZ", this.getDeathZ());
                ItemEntity itemEntity = this.m_19983_(stack);
            } else if (randomValue < (double)0.6f) {
                this.setDeathX((float)this.m_20185_());
                this.setDeathZ((float)this.m_20189_());
                ItemStack stack = new ItemStack((ItemLike)ModItems.SKELETON_CREW_ASSIGNMENT.get());
                stack.m_41751_(new CompoundTag());
                stack.m_41783_().m_128350_("DeathX", this.getDeathX());
                stack.m_41783_().m_128350_("DeathZ", this.getDeathZ());
                stack.m_41783_().m_128350_("Difficulty", (float)this.f_19796_.m_216339_(1, 3));
                ItemEntity itemEntity = this.m_19983_(stack);
            } else {
                ItemEntity itemEntity = this.m_19998_((ItemLike)ModItems.TREASURE_KEY.get());
            }
        }
    }

    @Override
    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.f_19796_.m_188501_();
        if (this.getCaptainGoldenVariant().equals((Object)CaptainGoldenSkeletonVariant.DEFAULT)) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41852_), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLACK_VEST.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_PANTS.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.5);
        } else if (randomValue < 0.1) {
            if ((double)this.f_19796_.m_188501_() < 0.3) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 1.0);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.5);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLACK_VEST.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_PANTS.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.8f);
        } else if (randomValue < 0.55) {
            if ((double)this.f_19796_.m_188501_() < 0.1) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 0.92f);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.08f);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.CAPTAIN_JACKET.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_PANTS.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.5);
        } else if (randomValue < 1.0) {
            if ((double)this.f_19796_.m_188501_() < 0.1) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.92f);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 0.08f);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.CAPTAIN_CROP_VEST.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_SKIRT.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.2f);
        }
        double randomValue2 = this.f_19796_.m_188501_();
        if (randomValue2 < 0.8) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_), pRandom, 0.95f);
        } else if (randomValue2 < 0.99) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_), pRandom, 0.95f);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42388_), pRandom, 1.0);
        }
    }

    public CaptainGoldenSkeletonVariant getCaptainGoldenVariant() {
        return CaptainGoldenSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(CaptainGoldenSkeletonVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean getCanDropKeysAndOrders() {
        return (Boolean)this.m_20088_().m_135370_(CAN_DROP_KEYS_AND_ORDERS);
    }

    public void setCanDropKeysAndOrders(boolean b) {
        this.m_20088_().m_135381_(CAN_DROP_KEYS_AND_ORDERS, (Object)b);
    }

    public float getDeathX() {
        return ((Float)this.m_20088_().m_135370_(DEATH_X)).floatValue();
    }

    public void setDeathX(float var) {
        this.m_20088_().m_135381_(DEATH_X, (Object)Float.valueOf(var));
    }

    public float getDeathZ() {
        return ((Float)this.m_20088_().m_135370_(DEATH_Z)).floatValue();
    }

    public void setDeathZ(float var) {
        this.m_20088_().m_135381_(DEATH_Z, (Object)Float.valueOf(var));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
        this.setDeathX(tag.m_128457_("DeathX"));
        this.setDeathZ(tag.m_128457_("DeathZ"));
        this.setCanDropKeysAndOrders(tag.m_128471_("CanDropKeysAndOrders"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
        tag.m_128350_("DeathX", this.getDeathX());
        tag.m_128350_("DeathZ", this.getDeathZ());
        tag.m_128379_("CanDropKeysAndOrders", this.getCanDropKeysAndOrders());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.m_20088_().m_135372_(DEATH_X, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DEATH_Z, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(CAN_DROP_KEYS_AND_ORDERS, (Object)true);
    }
}

