/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.GoldenSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import net.mrwilfis.treasures_of_the_dead.particle.ModParticles;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class GoldenSkeletonEntity
extends TOTDSkeletonEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(GoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SPEED_MODIFIER_RUSTED_UUID = UUID.fromString("75211345-f704-4de5-b9ec-5cbb31bfce54");
    private static final AttributeModifier SPEED_MODIFIER_RUSTED = new AttributeModifier(SPEED_MODIFIER_RUSTED_UUID, "Rusted Speed Modifier", -0.455, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> IS_RUSTED = SynchedEntityData.m_135353_(GoldenSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxRustedTime = 1200;
    private int rustedTimer = 0;
    private int maxTwitchTime = 10;
    private int twitchTimer = 0;

    public GoldenSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void specialProcedures() {
        GoldenSkeletonVariant variant = (GoldenSkeletonVariant)((Object)Util.m_214670_((Object[])GoldenSkeletonVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.f_19796_);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, (double)0.18f).m_22265_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getIsRusted() && this.f_19797_ % 7 == 0 && this.f_19796_.m_188501_() > 0.75f) {
            this.twitchTimer = this.maxTwitchTime;
            this.m_5496_(SoundEvents.f_11744_, 0.5f, 0.3f);
            this.m_9236_().m_7605_((Entity)this, (byte)42);
        }
        if (this.twitchTimer > 0) {
            --this.twitchTimer;
        }
        if (this.m_20071_()) {
            this.setIsRusted(true);
            this.rustedTimer = 0;
        }
        if (this.getIsRusted()) {
            ++this.rustedTimer;
            if (this.rustedTimer >= this.maxRustedTime) {
                this.setIsRusted(false);
                this.rustedTimer = 0;
            }
        }
        if (this.getIsRusted()) {
            if (!this.m_21051_(Attributes.f_22279_).m_22122_().contains(SPEED_MODIFIER_RUSTED)) {
                this.m_21051_(Attributes.f_22279_).m_22125_(SPEED_MODIFIER_RUSTED);
            }
        } else if (this.m_21051_(Attributes.f_22279_).m_22122_().contains(SPEED_MODIFIER_RUSTED)) {
            this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_RUSTED);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268444_) || source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268511_) || source.m_276093_(DamageTypes.f_268656_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268440_) || source.m_276093_(DamageTypes.f_268493_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        float newAmount = amount;
        if (source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268428_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268556_) || source.m_276093_(DamageTypes.f_268641_)) {
            newAmount = this.getIsRusted() ? amount * 2.0f : amount * 0.5f;
        } else if (source.m_276093_(DamageTypes.f_268714_) || source.m_276093_(DamageTypes.f_268425_) || source.m_276093_(DamageTypes.f_268526_) || source.m_276093_(DamageTypes.f_268513_) || source.m_276093_(DamageTypes.f_268659_)) {
            newAmount = this.getIsRusted() ? amount * 0.3f : amount * 0.2f;
        } else if (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
            newAmount = this.getIsRusted() ? amount * 1.5f : amount * 0.5f;
        } else if (source.m_276093_(DamageTypes.f_268464_) && source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_7500_()) {
            source.m_7639_().m_5496_(SoundEvents.f_12515_, 1.0f, 1.0f);
            source.m_7639_().m_5496_(SoundEvents.f_11669_, 1.0f, 1.5f);
            return false;
        }
        if (this.m_21224_()) {
            this.m_5496_(this.m_5592_(), 0.7f, 0.4f);
        }
        return super.m_6469_(source, newAmount);
    }

    protected void createRustedParticles(Level level, Random random, Vec3 position) {
        double xOffset = random.nextDouble() * 0.5 - 0.25;
        double yOffset = random.nextDouble() * 0.5 - 0.25;
        double zOffset = random.nextDouble() * 0.5 - 0.25;
        double xSpeed = random.nextDouble() * 0.4 - 0.2;
        double ySpeed = random.nextDouble() * 0.4 - 0.2;
        double zSpeed = random.nextDouble() * 0.4 - 0.2;
        for (int i = 0; i < random.nextInt(3, 6); ++i) {
            level.m_7106_((ParticleOptions)ModParticles.RUSTED_GOLDEN_SKELETON_PARTICLES.get(), position.f_82479_ + xOffset, position.f_82480_ + yOffset + 1.3, position.f_82481_ + zOffset, xSpeed += (double)random.nextFloat(-0.125f, 0.125f), (ySpeed += (double)random.nextFloat(-0.125f, 0.125f)) + (double)0.075f, zSpeed += (double)random.nextFloat(-0.125f, 0.125f));
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 42) {
            Random rand = new Random();
            this.createRustedParticles(this.m_9236_(), rand, this.m_20182_());
            if (this.f_19796_.m_188499_()) {
                this.triggerAnim("controller4", "rusty_twitch1");
            } else {
                this.triggerAnim("controller5", "rusty_twitch2");
            }
        }
    }

    private boolean isActuallyMoving() {
        float threshold;
        double dz;
        double dx = this.m_20185_() - this.f_19854_;
        return dx * dx + (dz = this.m_20189_() - this.f_19856_) * dz > (double)((threshold = 5.0E-5f) * threshold);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 3, this::idleAndWalk)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 3, this::walkAndAttack)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 0, this::spawning)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller4", 0, this::twitching).triggerableAnim("rusty_twitch1", RUSTY_TWITCH1)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller5", 0, this::twitching).triggerableAnim("rusty_twitch2", RUSTY_TWITCH2)});
    }

    private PlayState twitching(AnimationState<GoldenSkeletonEntity> state) {
        if (this.twitchTimer > 0) {
            // empty if block
        }
        return PlayState.CONTINUE;
    }

    private PlayState spawning(AnimationState<GoldenSkeletonEntity> state) {
        if (this.getIsSpawning()) {
            state.getController().setAnimation(SPAWN2);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState walkAndAttack(AnimationState<GoldenSkeletonEntity> state) {
        double modificator;
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        double d = modificator = this.getIsRusted() ? 2.8 : 1.444;
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.f_20911_) {
            state.getController().stop();
            state.getController().setAnimation(ATTACK1);
            state.getController().setAnimationSpeed(0.8);
            return PlayState.CONTINUE;
        }
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().stop();
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.25 / modificator);
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.0 / modificator);
            return PlayState.CONTINUE;
        }
        if (!this.isActuallyMoving() && !this.f_20911_) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private PlayState idleAndWalk(AnimationState<GoldenSkeletonEntity> state) {
        double modificator;
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        double d = modificator = this.getIsRusted() ? 2.8 : 1.444;
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.isActuallyMoving() && this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.6875 / modificator);
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving() && !this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.35 / modificator);
            return PlayState.CONTINUE;
        }
        if (!this.isActuallyMoving() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(IDLE_KEG);
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.25 / modificator);
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.0 / modificator);
            if ((double)this.f_19796_.m_188501_() < 0.5) {
                this.idleVariation = 1;
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.idleVariation = 2;
            }
            return PlayState.CONTINUE;
        }
        if (!this.isActuallyMoving()) {
            if (this.idleVariation == 1) {
                state.getController().setAnimation(IDLE1);
            } else if (this.idleVariation == 2) {
                state.getController().setAnimation(IDLE2);
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_11746_;
    }

    @Override
    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.5f, 0.2f);
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11745_;
    }

    protected void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(this.m_7975_(source), 0.6f, 0.5f);
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11794_;
    }

    public void m_8032_() {
        this.m_5496_(this.m_7515_(), this.m_6121_(), 0.7f);
    }

    public GoldenSkeletonVariant getGoldenVariant() {
        return GoldenSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(GoldenSkeletonVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean getIsRusted() {
        return (Boolean)this.f_19804_.m_135370_(IS_RUSTED);
    }

    public void setIsRusted(boolean b) {
        this.f_19804_.m_135381_(IS_RUSTED, (Object)b);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
        this.f_19804_.m_135381_(IS_RUSTED, (Object)tag.m_128471_("IsRusted"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
        tag.m_128379_("IsRusted", this.getIsRusted());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.m_20088_().m_135372_(IS_RUSTED, (Object)false);
    }
}

