/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.ShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import net.mrwilfis.treasures_of_the_dead.misc.TOTDBlockPos;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class ShadowSkeletonEntity
extends TOTDSkeletonEntity {
    private static final EntityDataAccessor<Boolean> IS_SHADOW = SynchedEntityData.m_135353_(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHADOW_TIMER = SynchedEntityData.m_135353_(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isShaking = false;
    private int shakingTimer = 0;
    private final int shadowTimer = 600;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ShadowSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void specialProcedures() {
        ShadowSkeletonVariant variant = (ShadowSkeletonVariant)((Object)Util.m_214670_((Object[])ShadowSkeletonVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.f_19796_);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22265_();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 3, this::idleAndWalk2)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 3, this::walkAndAttack2)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 0, this::spawning)});
    }

    private <E extends GeoAnimatable> PlayState spawning(AnimationState<E> state) {
        if (this.getIsSpawning()) {
            state.getController().setAnimation(SPAWN2);
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState walkAndAttack2(AnimationState<E> state) {
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.getShadowTimer() >= 600) {
            if (mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
                state.getController().setAnimation(SHAKING_FROM_LIGHT_WITH_KEG);
                state.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(SHAKING_FROM_LIGHT);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.f_20911_) {
            state.getController().stop();
            state.getController().setAnimation(ATTACK1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().stop();
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !this.f_20911_) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState idleAndWalk2(AnimationState<E> state) {
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.getShadowTimer() >= 600) {
            if (mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
                state.getController().setAnimation(SHAKING_FROM_LIGHT_WITH_KEG);
                state.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(SHAKING_FROM_LIGHT);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.6875);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.35);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(IDLE_KEG);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.0);
            if ((double)this.f_19796_.m_188501_() < 0.5) {
                this.idleVariation = 1;
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.idleVariation = 2;
            }
            return PlayState.CONTINUE;
        }
        if (!state.isMoving()) {
            if (this.idleVariation == 1) {
                state.getController().setAnimation(IDLE1);
            } else if (this.idleVariation == 2) {
                state.getController().setAnimation(IDLE2);
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            BlockPos Pos = this.getLightPosition();
            int j = this.m_9236_().m_45517_(LightLayer.BLOCK, Pos);
            int i = this.m_9236_().m_46462_() ? 0 : this.m_9236_().m_45517_(LightLayer.SKY, Pos);
            int brightness = Math.max(i, j);
            if (this.isShaking) {
                this.setShadow(false);
                this.m_20331_(false);
                this.m_21557_(true);
                --this.shakingTimer;
                if (this.shakingTimer <= 0) {
                    this.setShadowTimer(this.getShadowTimer() - 1);
                    this.isShaking = false;
                    this.m_21557_(false);
                }
            }
            if (brightness >= 7) {
                if (this.getShadow() && !this.isShaking) {
                    this.isShaking = true;
                    this.shakingTimer = 60;
                    this.m_5496_(SoundEvents.f_12644_, 0.5f, 0.75f);
                    this.m_5496_(SoundEvents.f_215672_, 1.0f, 0.0f);
                    this.setShadowTimer(600);
                }
            } else {
                if (!this.getShadow() && this.getShadowTimer() > 0 && !this.isShaking) {
                    this.setShadowTimer(this.getShadowTimer() - 1);
                }
                if (this.getShadowTimer() <= 0) {
                    this.setShadow(true);
                    this.m_20331_(true);
                }
            }
        }
    }

    @Override
    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.f_19796_.m_188501_();
        if (randomValue < 0.2) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_), pRandom, 0.5);
        } else if (randomValue < 0.95) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_), pRandom, 0.5);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.POWDER_KEG_ITEM.get()), pRandom, 1.0);
        }
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (mainHandItem.m_41720_() == ModItems.POWDER_KEG_ITEM.get()) {
            this.m_21559_(false);
            this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
        }
    }

    public BlockPos getLightPosition() {
        BlockPos pos = TOTDBlockPos.fromVec3(this.m_20182_());
        if (!this.m_9236_().m_8055_(pos).m_60815_()) {
            return pos.m_7494_();
        }
        return pos;
    }

    public int getShadowTimer() {
        return (Integer)this.m_20088_().m_135370_(SHADOW_TIMER);
    }

    public void setShadowTimer(int i) {
        this.m_20088_().m_135381_(SHADOW_TIMER, (Object)i);
    }

    public boolean getShadow() {
        return (Boolean)this.m_20088_().m_135370_(IS_SHADOW);
    }

    public void setShadow(boolean b) {
        this.m_20088_().m_135381_(IS_SHADOW, (Object)b);
    }

    public ShadowSkeletonVariant getShadowVariant() {
        return ShadowSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(ShadowSkeletonVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
        this.setShadowTimer(tag.m_128451_("ShadowTimer"));
        this.setShadow(tag.m_128471_("IsShadow"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
        tag.m_128405_("ShadowTimer", this.getShadowTimer());
        tag.m_128379_("IsShadow", this.getShadow());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SHADOW_TIMER, (Object)0);
        this.m_20088_().m_135372_(IS_SHADOW, (Object)true);
    }
}

