/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.mrwilfis.treasures_of_the_dead.TOTDUtils;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainBloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainGoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.GoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.ShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;

public class SkeletonCrewCamp
extends Entity {
    private final List<LivingEntity> campSkeletons = new ArrayList<LivingEntity>();
    private final List<UUID> campSkeletonUUIDs = new ArrayList<UUID>();
    private final List<LivingEntity> skeletonsToSpawn = new ArrayList<LivingEntity>();
    private boolean loaded = false;
    private int countPirates;
    private int countCaptains;
    private int difficulty;
    private int maxWaves;
    private int currentWave = 0;
    private boolean isFinalWave;
    private int wavesCooldown = 100;
    private int waveCDTimer = 0;
    private int skeletonSpawnCDTimer = 0;
    private String[] currentWaveSkeletonTypes = new String[0];
    private final Random rand = new Random();
    private final Map<String, String> pirateTypeToCaptainType = new HashMap<String, String>();

    public SkeletonCrewCamp(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.pirateTypeToCaptainTypeMethod();
    }

    public SkeletonCrewCamp(EntityType<?> entityType, Level level, int difficulty, int waves) {
        super(entityType, level);
        this.difficulty = difficulty;
        this.maxWaves = waves;
        this.pirateTypeToCaptainTypeMethod();
    }

    private void pirateTypeToCaptainTypeMethod() {
        this.pirateTypeToCaptainType.put("treasures_of_the_dead:totd_skeleton", "treasures_of_the_dead:captain_skeleton");
        this.pirateTypeToCaptainType.put("treasures_of_the_dead:blooming_skeleton", "treasures_of_the_dead:captain_blooming_skeleton");
        this.pirateTypeToCaptainType.put("treasures_of_the_dead:shadow_skeleton", "treasures_of_the_dead:captain_shadow_skeleton");
        this.pirateTypeToCaptainType.put("treasures_of_the_dead:golden_skeleton", "treasures_of_the_dead:captain_golden_skeleton");
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.skeletonSpawnCDTimer > 0) {
            --this.skeletonSpawnCDTimer;
        }
        if ((long)this.f_19797_ > 48000L) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.loaded) {
            this.loadCampSkeletonsFromUUID();
            if (!this.m_9236_().f_46443_) {
                this.loadMaxWaves();
                this.loadWavesCoolDown();
            }
            this.loaded = true;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.campSkeletons.isEmpty()) {
                if (this.waveCDTimer > 0) {
                    --this.waveCDTimer;
                } else if (this.currentWave < this.maxWaves) {
                    this.spawnNextWave();
                    ++this.currentWave;
                } else {
                    this.m_146870_();
                }
            } else {
                this.campSkeletons.removeIf(skeleton -> {
                    if (!skeleton.m_6084_()) {
                        this.campSkeletonUUIDs.remove(skeleton.m_20148_());
                        return true;
                    }
                    return false;
                });
                if (this.campSkeletons.isEmpty()) {
                    this.waveCDTimer = this.wavesCooldown;
                }
            }
        }
        if (!this.m_9236_().f_46443_ && !this.skeletonsToSpawn.isEmpty() && this.skeletonSpawnCDTimer <= 0) {
            int calculatedSpawnCD;
            LivingEntity entity = this.skeletonsToSpawn.get(0);
            this.skeletonsToSpawn.remove(0);
            this.campSkeletons.add(entity);
            this.campSkeletonUUIDs.add(entity.m_20148_());
            this.m_9236_().m_7967_((Entity)entity);
            if (entity instanceof Monster) {
                Monster entity1 = (Monster)entity;
                entity1.m_8032_();
            }
            int totalSkeletonsInWave = this.countPirates + (this.currentWave + 1 == this.maxWaves ? this.countCaptains : 0);
            this.skeletonSpawnCDTimer = calculatedSpawnCD = Math.max(1, (int)(30.0f / (float)totalSkeletonsInWave));
        }
    }

    private void spawnNextWave() {
        BlockPos pos;
        List<Map.Entry<String, Integer>> entitiesConfigs = this.loadEntityConfigFromJson(this, "raid_entity_data/camp/camp_" + this.difficulty + ".json", "entities");
        if (entitiesConfigs.isEmpty()) {
            System.err.println("Error: unable to load entity config for difficulty " + this.difficulty);
            return;
        }
        Map<String, Integer> entitiesCount = TOTDUtils.loadMinMaxParameterFromJson(this, "raid_entity_data/camp/camp_" + this.difficulty + ".json", "entities_count");
        if (entitiesCount.isEmpty()) {
            System.err.println("Error: unable to load entity config for difficulty " + this.difficulty);
            this.countPirates = 5;
        } else {
            int max;
            int min = entitiesCount.get("min");
            if (min <= (max = entitiesCount.get("max").intValue())) {
                this.countPirates = this.f_19796_.m_216339_(min, max + 1);
            } else {
                System.err.println("Error: min is higher than max in json file camp_" + this.difficulty + ".json (entities_count)");
            }
        }
        Map<String, Integer> bossCount = TOTDUtils.loadMinMaxParameterFromJson(this, "raid_entity_data/camp/camp_" + this.difficulty + ".json", "boss_count");
        if (bossCount.isEmpty()) {
            System.err.println("Error: unable to load entity config for difficulty " + this.difficulty);
            this.countCaptains = 1;
        } else {
            int max;
            int min = bossCount.get("min");
            if (min <= (max = bossCount.get("max").intValue())) {
                this.countCaptains = this.f_19796_.m_216339_(min, max + 1);
            } else {
                System.err.println("Error: min is higher than max in json file camp_" + this.difficulty + ".json (boss_count)");
            }
        }
        this.selectEntityTypesForWave(entitiesConfigs);
        for (int i = 0; i < this.countPirates; ++i) {
            String selectedType = this.currentWaveSkeletonTypes[this.rand.nextInt(this.currentWaveSkeletonTypes.length)];
            LivingEntity pirate = this.newEntity(selectedType);
            if (pirate == null) continue;
            pos = this.findNearbyPos();
            pirate.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.rand.nextFloat(-180.0f, 180.0f), 0.0f);
            pirate = this.specialProcedures(pirate);
            this.skeletonsToSpawn.add(pirate);
        }
        if (this.currentWave + 1 == this.maxWaves) {
            for (int j = 0; j < this.countCaptains; ++j) {
                String selectedType = this.currentWaveSkeletonTypes[this.rand.nextInt(this.currentWaveSkeletonTypes.length)];
                LivingEntity captain = this.newEntity(this.pirateTypeToCaptainType.get(selectedType));
                if (captain == null) continue;
                pos = this.findNearbyPos();
                captain.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.rand.nextFloat(-180.0f, 180.0f), 0.0f);
                captain = this.specialProcedures(captain);
                this.skeletonsToSpawn.add(captain);
            }
        }
    }

    private void selectEntityTypesForWave(List<Map.Entry<String, Integer>> configs) {
        ArrayList<String> selectedTypes = new ArrayList<String>();
        int totalWeight = configs.stream().mapToInt(Map.Entry::getValue).sum();
        int numTypes = this.difficulty > 3 ? 2 : 1;
        for (int i = 0; i < numTypes; ++i) {
            int randomWeight = this.rand.nextInt(totalWeight);
            int currentWeight = 0;
            String chosenType = null;
            for (Map.Entry<String, Integer> config : configs) {
                if (randomWeight >= (currentWeight += config.getValue().intValue())) continue;
                chosenType = config.getKey();
                break;
            }
            if (chosenType == null) continue;
            selectedTypes.add(chosenType);
        }
        this.currentWaveSkeletonTypes = selectedTypes.toArray(new String[0]);
    }

    private LivingEntity newEntity(String typeId) {
        EntityType entityType = EntityType.m_20632_((String)typeId).orElse((EntityType)ModEntities.BLOOMING_SKELETON.get());
        LivingEntity entity = (LivingEntity)entityType.m_20615_(this.m_9236_());
        if (entity != null) {
            return entity;
        }
        return null;
    }

    private LivingEntity specialProcedures(LivingEntity entity) {
        TOTDSkeletonEntity entity1;
        TOTDSkeletonEntity entity12;
        TOTDSkeletonEntity entity13;
        TOTDSkeletonEntity entity14;
        entity.m_20049_("TOTD_Rotate");
        ((Monster)entity).m_21530_();
        if (entity instanceof TOTDSkeletonEntity) {
            entity14 = (TOTDSkeletonEntity)entity;
            entity14.setIsSpawning(true);
            entity14.setCampUUID(this.m_20148_());
        }
        if (entity instanceof BloomingSkeletonEntity) {
            entity14 = (BloomingSkeletonEntity)entity;
            ((BloomingSkeletonEntity)entity14).specialProcedures();
        } else if (entity instanceof ShadowSkeletonEntity) {
            entity13 = (ShadowSkeletonEntity)entity;
            ((ShadowSkeletonEntity)entity13).specialProcedures();
        } else if (entity instanceof GoldenSkeletonEntity) {
            entity12 = (GoldenSkeletonEntity)entity;
            ((GoldenSkeletonEntity)entity12).specialProcedures();
        } else if (entity instanceof TOTDSkeletonEntity) {
            entity1 = (TOTDSkeletonEntity)entity;
            entity1.specialProcedures();
        }
        if (entity instanceof CaptainSkeletonEntity) {
            entity14 = (CaptainSkeletonEntity)entity;
            ((CaptainSkeletonEntity)entity14).specialProcedures();
            ((CaptainSkeletonEntity)entity14).setCanDropKeysAndOrders(false);
        } else if (entity instanceof CaptainBloomingSkeletonEntity) {
            entity13 = (CaptainBloomingSkeletonEntity)entity;
            ((CaptainBloomingSkeletonEntity)entity13).specialProcedures();
            ((CaptainBloomingSkeletonEntity)entity13).setCanDropKeysAndOrders(false);
        } else if (entity instanceof CaptainShadowSkeletonEntity) {
            entity12 = (CaptainShadowSkeletonEntity)entity;
            ((CaptainShadowSkeletonEntity)entity12).specialProcedures();
            ((CaptainShadowSkeletonEntity)entity12).setCanDropKeysAndOrders(false);
        } else if (entity instanceof CaptainGoldenSkeletonEntity) {
            entity1 = (CaptainGoldenSkeletonEntity)entity;
            ((CaptainGoldenSkeletonEntity)entity1).specialProcedures();
            ((CaptainGoldenSkeletonEntity)entity1).setCanDropKeysAndOrders(false);
        }
        return entity;
    }

    private void loadWavesCoolDown() {
        int wavesCooldown = TOTDUtils.loadIntParameterFromJson(this, "raid_entity_data/camp/camp_" + this.difficulty + ".json", "waves_cooldown");
        if (wavesCooldown < 0) {
            System.err.println("Error: waves cooldown are lower than 0 in camp_ " + this.difficulty + ".json");
            this.wavesCooldown = 100;
        } else {
            this.wavesCooldown = wavesCooldown;
        }
    }

    private void loadMaxWaves() {
        Map<String, Integer> waves = TOTDUtils.loadMinMaxParameterFromJson(this, "raid_entity_data/camp/camp_" + this.difficulty + ".json", "waves");
        if (waves.isEmpty()) {
            System.err.println("Error: unable to load entity config for difficulty " + this.difficulty);
        } else {
            int max;
            int min = waves.get("min");
            if (min <= (max = waves.get("max").intValue())) {
                if (this.maxWaves < min) {
                    this.maxWaves = this.f_19796_.m_216339_(min, max + 1);
                }
            } else {
                System.err.println("Error: min is higher than max in json file camp_" + this.difficulty + ".json (waves)");
            }
        }
    }

    private BlockPos findNearbyPos() {
        int x = (int)this.m_20185_() + this.rand.nextInt(-4, 4);
        int z = (int)this.m_20189_() + this.rand.nextInt(-4, 4);
        int y = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        return new BlockPos(x, y, z);
    }

    private List<Map.Entry<String, Integer>> loadEntityConfigFromJson(Entity thisEntity, String JsonPath, String entitiesOrBosses) {
        ArrayList<Map.Entry<String, Integer>> configs = new ArrayList<Map.Entry<String, Integer>>();
        Level level = thisEntity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return configs;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        ResourceManager resourceManager = serverlevel.m_7654_().m_177941_();
        ResourceLocation configLocation = Treasures_of_the_dead.resource(JsonPath);
        try {
            Resource resource = (Resource)resourceManager.m_213713_(configLocation).orElseThrow();
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(resource.m_215507_())).getAsJsonObject();
            JsonArray skeletonsArray = json.getAsJsonArray(entitiesOrBosses);
            for (JsonElement elem : skeletonsArray) {
                JsonObject skeletonObj = elem.getAsJsonObject();
                String type = skeletonObj.get("type").getAsString();
                int weight = skeletonObj.get("weight").getAsInt();
                configs.add(Map.entry(type, weight));
            }
        }
        catch (Exception e) {
            System.err.println("Error loading JSON for " + configLocation + ":" + e.getMessage());
        }
        return configs;
    }

    private void loadCampSkeletonsFromUUID() {
        this.campSkeletons.clear();
        for (UUID uuid : this.campSkeletonUUIDs) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
            if (entity instanceof TOTDSkeletonEntity) {
                TOTDSkeletonEntity pirate = (TOTDSkeletonEntity)entity;
                this.campSkeletons.add((LivingEntity)pirate);
                continue;
            }
            this.campSkeletonUUIDs.remove(uuid);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.maxWaves = tag.m_128441_("MaxWaves") ? tag.m_128451_("MaxWaves") : 3;
        this.currentWave = tag.m_128441_("CurrentWave") ? tag.m_128451_("CurrentWave") : 0;
        this.difficulty = tag.m_128441_("Difficulty") ? tag.m_128451_("Difficulty") : 1;
        this.wavesCooldown = tag.m_128441_("WavesCooldown") ? tag.m_128451_("WavesCooldown") : 100;
        if (tag.m_128441_("CampSkeletonsUUIDs")) {
            ListTag piratesTag = tag.m_128437_("CampSkeletonsUUIDs", 11);
            this.campSkeletonUUIDs.clear();
            for (int i = 0; i < piratesTag.size(); ++i) {
                this.campSkeletonUUIDs.add(NbtUtils.m_129233_((Tag)piratesTag.get(i)));
            }
        } else {
            this.campSkeletonUUIDs.clear();
        }
        this.loaded = false;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("MaxWaves", this.maxWaves);
        tag.m_128405_("CurrentWave", this.currentWave);
        tag.m_128405_("Difficulty", this.difficulty);
        tag.m_128405_("WavesCooldown", this.wavesCooldown);
        ListTag piratesTag = new ListTag();
        for (UUID uuid : this.campSkeletonUUIDs) {
            piratesTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        tag.m_128365_("CampSkeletonsUUIDs", (Tag)piratesTag);
    }
}

