/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.variant.TOTDSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TOTDSkeletonEntity
extends Monster
implements GeoAnimatable,
GeoEntity {
    protected int idleVariation;
    private final int maxSpawningTime = 80;
    private int spawningTime;
    private int maxPrepareToBlowUp;
    private int prepareToBlowUp;
    private final AnimatableInstanceCache cache;
    private UUID campUUID;
    private static final double MAX_DISTANCE_FROM_CAMP = 15.0;
    private static final UUID SPEED_MODIFIER_WITH_KEG_UUID = UUID.fromString("d27bb1e7-92bc-4161-8e9d-2f9a52b1598e");
    private static final AttributeModifier SPEED_MODIFIER_WITH_KEG = new AttributeModifier(SPEED_MODIFIER_WITH_KEG_UUID, "Keg Speed Modifier", -0.3, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_GOING_TO_BLOW_UP = SynchedEntityData.m_135353_(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SPAWNING = SynchedEntityData.m_135353_(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final RawAnimation WALK_BODY1 = RawAnimation.begin().then("animation.model.walk_body1", Animation.LoopType.LOOP);
    protected static final RawAnimation WALK_HANDS1 = RawAnimation.begin().then("animation.model.walk_hands1", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE1 = RawAnimation.begin().then("animation.model.idle1", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE2 = RawAnimation.begin().then("animation.model.idle2", Animation.LoopType.LOOP);
    protected static final RawAnimation ATTACK1 = RawAnimation.begin().then("animation.model.attack1", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation SHAKING_FROM_LIGHT = RawAnimation.begin().then("animation.model.shaking_from_light", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation SHAKING_FROM_LIGHT_WITH_KEG = RawAnimation.begin().then("animation.model.shaking_from_light_with_keg", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation WALK_KEG = RawAnimation.begin().then("animation.model.walk_keg", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE_KEG = RawAnimation.begin().then("animation.model.idle_keg", Animation.LoopType.LOOP);
    protected static final RawAnimation SPAWN2 = RawAnimation.begin().then("animation.model.spawn2", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation RUSTY_TWITCH1 = RawAnimation.begin().then("animation.model.rusty_twitch1", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation RUSTY_TWITCH2 = RawAnimation.begin().then("animation.model.rusty_twitch2", Animation.LoopType.PLAY_ONCE);

    public TOTDSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.idleVariation = this.f_19796_.m_216339_(1, 3);
        this.maxSpawningTime = 80;
        this.spawningTime = 0;
        this.maxPrepareToBlowUp = 90;
        this.prepareToBlowUp = 0;
        this.cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
        this.campUUID = null;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        boolean b;
        boolean bl = b = pReason.equals((Object)MobSpawnType.SPAWN_EGG) || pReason.equals((Object)MobSpawnType.SPAWNER) || pReason.equals((Object)MobSpawnType.DISPENSER) || pReason.equals((Object)MobSpawnType.MOB_SUMMONED);
        if (!b) {
            this.setIsSpawning(true);
            this.m_8032_();
        }
        this.specialProcedures();
        this.m_213946_(this.f_19796_, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void specialProcedures() {
        TOTDSkeletonVariant variant = (TOTDSkeletonVariant)((Object)Util.m_214670_((Object[])TOTDSkeletonVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.f_19796_);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, (double)0.24f).m_22265_();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            ItemStack mainHandItem;
            double distance;
            Entity camp;
            if (this.campUUID != null && (camp = ((ServerLevel)this.m_9236_()).m_8791_(this.campUUID)) != null && !this.m_5912_() && (distance = (double)this.m_20270_(camp)) > 15.0) {
                this.m_21573_().m_26519_(camp.m_20185_(), camp.m_20186_(), camp.m_20189_(), 1.25);
            }
            if (!(mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
                LivingEntity target;
                if (!this.m_21051_(Attributes.f_22279_).m_22122_().contains(SPEED_MODIFIER_WITH_KEG)) {
                    this.m_21051_(Attributes.f_22279_).m_22125_(SPEED_MODIFIER_WITH_KEG);
                }
                if (this.prepareToBlowUp >= this.maxPrepareToBlowUp) {
                    this.explodeSkeleton();
                }
                if ((target = this.m_5448_()) == null) {
                    this.setIsGoingToBlowUp(false);
                } else if (this.m_20280_((Entity)target) > 64.0) {
                    this.setIsGoingToBlowUp(false);
                } else if (this.m_20280_((Entity)target) < 25.0) {
                    this.setIsGoingToBlowUp(true);
                }
                boolean $$0 = this.getIsGoingToBlowUp();
                if ($$0 && this.prepareToBlowUp == 0) {
                    this.m_5496_(SoundEvents.f_12512_, 1.0f, 0.5f);
                }
                this.prepareToBlowUp = $$0 ? ++this.prepareToBlowUp : 0;
            } else if (this.m_21051_(Attributes.f_22279_).m_22122_().contains(SPEED_MODIFIER_WITH_KEG)) {
                this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_WITH_KEG);
            }
            if (this.getIsSpawning()) {
                this.m_21557_(true);
                ++this.spawningTime;
            }
            if (this.spawningTime >= 80) {
                this.m_21557_(false);
                this.setIsSpawning(false);
                this.spawningTime = 0;
            }
        }
        super.m_8119_();
        if (this.getIsGoingToBlowUp()) {
            this.createFuseParticles(this.m_9236_(), this.f_19796_, this);
        }
    }

    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.f_19796_.m_188501_();
        if (randomValue < 0.3) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BOOTS.get()), pRandom, 0.7f);
        } else if (randomValue < 0.6) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLACK_VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.BLACK_PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.7f);
        } else if (randomValue < 0.9) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLUE_VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.BLUE_PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLUE_BOOTS.get()), pRandom, 0.7f);
        }
        randomValue = this.f_19796_.m_188501_();
        if (randomValue < 0.25) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.GREEN_BANDANA.get()), pRandom, 0.6f);
        } else if (randomValue < 0.5) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.RED_BANDANA.get()), pRandom, 0.6f);
        } else if (randomValue < 0.75) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BLUE_BANDANA.get()), pRandom, 0.6f);
        }
        randomValue = this.f_19796_.m_188501_();
        if (randomValue < 0.2) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_), pRandom, 0.5);
        } else if (randomValue < 0.95) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_), pRandom, 0.5);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.POWDER_KEG_ITEM.get()), pRandom, 1.0);
        }
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (mainHandItem.m_41720_() == ModItems.POWDER_KEG_ITEM.get()) {
            this.m_21559_(false);
            this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
        }
    }

    public void spawnRandomBandanas(RandomSource pRandom) {
        double randomValue = this.f_19796_.m_188501_();
        if (randomValue < 0.33) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.GREEN_BANDANA.get()), pRandom, 1.0);
        } else if (randomValue < 0.67) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.RED_BANDANA.get()), pRandom, 1.0);
        } else if (randomValue < 1.0) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BLUE_BANDANA.get()), pRandom, 1.0);
        }
    }

    public void maybeWearEquipment(EquipmentSlot pSlot, ItemStack pStack, RandomSource pRandom, double chance) {
        if ((double)pRandom.m_188501_() < chance) {
            this.m_8061_(pSlot, pStack);
        }
    }

    protected void explodeSkeleton() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, TOTDSkeletonEntity entity) {
        Vec3 entityPos = entity.m_20182_();
        float yaw = entity.m_146908_();
        double radians = Math.toRadians(yaw);
        Vec3 bodyDirection = new Vec3(-Math.sin(radians), 0.0, Math.cos(radians)).m_82541_();
        double distance = 0.25;
        Vec3 particlePosition = entityPos.m_82549_(bodyDirection.m_82490_(distance));
        double xOffset = random.m_188500_() * 0.2 - 0.1;
        double yOffset = random.m_188500_() * 0.2 - 0.1;
        double zOffset = random.m_188500_() * 0.2 - 0.1;
        double xSpeed = random.m_188500_() * 0.04 - 0.02;
        double ySpeed = random.m_188500_() * 0.06 + 0.03;
        double zSpeed = random.m_188500_() * 0.04 - 0.02;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, particlePosition.f_82479_ + xOffset, particlePosition.f_82480_ + yOffset + 1.7, particlePosition.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TOTDSkeletonEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 3, this::idleAndWalk)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 3, this::walkAndAttack)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 0, this::spawning)});
    }

    private <E extends GeoAnimatable> PlayState spawning(AnimationState<E> state) {
        if (this.getIsSpawning()) {
            state.getController().setAnimation(SPAWN2);
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState walkAndAttack(AnimationState<E> state) {
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.f_20911_) {
            state.getController().stop();
            state.getController().setAnimation(ATTACK1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().stop();
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !this.f_20911_) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState idleAndWalk(AnimationState<E> state) {
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (state.isMoving() && this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.6875);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.35);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(IDLE_KEG);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.m_5912_()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.0);
            if ((double)this.f_19796_.m_188501_() < 0.5) {
                this.idleVariation = 1;
            } else if ((double)this.f_19796_.m_188501_() < 1.0) {
                this.idleVariation = 2;
            }
            return PlayState.CONTINUE;
        }
        if (!state.isMoving()) {
            if (this.idleVariation == 1) {
                state.getController().setAnimation(IDLE1);
            } else if (this.idleVariation == 2) {
                state.getController().setAnimation(IDLE2);
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public double getTick(Object o) {
        return ((Entity)o).f_19797_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void setCampUUID(UUID uuid) {
        this.campUUID = uuid;
    }

    public boolean getIsSpawning() {
        return (Boolean)this.m_20088_().m_135370_(IS_SPAWNING);
    }

    public void setIsSpawning(boolean b) {
        this.m_20088_().m_135381_(IS_SPAWNING, (Object)b);
    }

    public boolean getIsGoingToBlowUp() {
        return (Boolean)this.m_20088_().m_135370_(IS_GOING_TO_BLOW_UP);
    }

    public void setIsGoingToBlowUp(boolean b) {
        this.m_20088_().m_135381_(IS_GOING_TO_BLOW_UP, (Object)b);
    }

    public TOTDSkeletonVariant getVariant() {
        return TOTDSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(TOTDSkeletonVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
        this.setIsGoingToBlowUp(tag.m_128471_("IsGoingToBlowUp"));
        this.setIsSpawning(tag.m_128471_("IsSpawning"));
        this.campUUID = tag.m_128441_("CampUUID") ? tag.m_128342_("CampUUID") : null;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
        tag.m_128379_("IsGoingToBlowUp", this.getIsGoingToBlowUp());
        tag.m_128379_("IsSpawning", this.getIsSpawning());
        if (this.campUUID != null) {
            tag.m_128362_("CampUUID", this.campUUID);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.m_20088_().m_135372_(IS_GOING_TO_BLOW_UP, (Object)false);
        this.m_20088_().m_135372_(IS_SPAWNING, (Object)false);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

