/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbstractPowderKegItem
extends Item {
    public int maxPrepareToBlowUp = this.getMaxPrepareToBlowUp();
    public float explodeRadius = this.getExplodeRadius();

    public AbstractPowderKegItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack kegItem = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            boolean b = AbstractPowderKegItem.getIsGoingToBlowUp(kegItem);
            if (!b) {
                AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, true);
            } else {
                AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
            }
        }
        return InteractionResultHolder.m_19098_((Object)kegItem);
    }

    public void m_6883_(ItemStack kegItem, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.f_46443_) {
            if (!pIsSelected) {
                if (AbstractPowderKegItem.getIsGoingToBlowUp(kegItem)) {
                    AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
                }
            } else {
                boolean b = AbstractPowderKegItem.getIsGoingToBlowUp(kegItem);
                int i = AbstractPowderKegItem.getPrepareToBlowUp(kegItem);
                if (b) {
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, i + 1);
                } else if (i != 0) {
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
                }
                if (i >= this.maxPrepareToBlowUp) {
                    this.explodeKeg((LivingEntity)pEntity, kegItem);
                }
                if (b && i == 0) {
                    pLevel.m_6263_((Player)null, pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_(), SoundEvents.f_12512_, SoundSource.PLAYERS, 1.0f, 0.5f);
                }
            }
        }
        if (AbstractPowderKegItem.getIsGoingToBlowUp(kegItem)) {
            this.createFuseParticles(pLevel, pLevel.f_46441_, pEntity);
        }
        super.m_6883_(kegItem, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void explodeKeg(LivingEntity livingEntity, ItemStack kegItem) {
        if (!livingEntity.m_9236_().f_46443_) {
            kegItem.m_41774_(1);
            livingEntity.m_9236_().m_254849_((Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), this.explodeRadius, Level.ExplosionInteraction.MOB);
            AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
            AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
            livingEntity.m_6469_(livingEntity.m_269291_().m_269036_((Entity)livingEntity, (Entity)livingEntity), 50.0f);
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, Entity entity) {
        Vec3 entityPos = entity.m_20182_();
        float yaw = entity.m_146908_();
        double radians = Math.toRadians(yaw);
        Vec3 bodyDirection = new Vec3(-Math.sin(radians), 0.0, Math.cos(radians)).m_82541_();
        double distance = 0.35;
        Vec3 particlePosition = entityPos.m_82549_(bodyDirection.m_82490_(distance));
        double xOffset = random.m_188500_() * 0.2 - 0.1;
        double yOffset = random.m_188500_() * 0.2 - 0.1;
        double zOffset = random.m_188500_() * 0.2 - 0.1;
        double xSpeed = random.m_188500_() * 0.04 - 0.02;
        double ySpeed = random.m_188500_() * 0.06 + 0.03;
        double zSpeed = random.m_188500_() * 0.04 - 0.02;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, particlePosition.f_82479_ + xOffset, particlePosition.f_82480_ + yOffset + 0.6 * (double)entity.m_20206_(), particlePosition.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
    }

    private float getExplodeRadius() {
        return 3.0f;
    }

    private int getMaxPrepareToBlowUp() {
        return 90;
    }

    public static boolean getIsGoingToBlowUp(ItemStack kegItem) {
        CompoundTag compoundtag = kegItem.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("IsGoingToBlowUp");
    }

    public static void setIsGoingToBlowUp(ItemStack kegItem, boolean b) {
        CompoundTag compoundtag = kegItem.m_41784_();
        compoundtag.m_128379_("IsGoingToBlowUp", b);
    }

    public static int getPrepareToBlowUp(ItemStack kegItem) {
        CompoundTag compoundtag = kegItem.m_41783_();
        if (compoundtag != null) {
            return compoundtag.m_128451_("PrepareToBlowUp");
        }
        return 0;
    }

    public static void setPrepareToBlowUp(ItemStack kegItem, int i) {
        CompoundTag compoundtag = kegItem.m_41784_();
        compoundtag.m_128405_("PrepareToBlowUp", i);
    }
}

