/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.mrwilfis.treasures_of_the_dead.Config;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainBloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.ShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.SkeletonCrewCamp;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.chestVariants.TreasureChestEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.skullVariants.VillainousSkullEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.BloomingSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainBloomingSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.ShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.TOTDSkeletonVariant;
import org.jetbrains.annotations.Nullable;

public class RandomSpawningAdventureItem
extends Item {
    private final String taskType;

    public RandomSpawningAdventureItem(Item.Properties pProperties, String taskType) {
        super(pProperties);
        this.taskType = taskType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pUsedHand) {
        int range = Config.randomAdventureItemDistanceInChunks * 16;
        RandomSource random = level.m_213780_();
        Random rand = new Random();
        double randomValue = 0.0;
        if (this.taskType.equals("random_task")) {
            randomValue = random.m_188500_();
        }
        ItemStack stack = player.m_21120_(pUsedHand);
        double X = player.m_20185_();
        double Y = player.m_20186_();
        double Z = player.m_20189_();
        int difficulty = 0;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("DeathX") && stack.m_41783_().m_128441_("DeathZ")) {
            X = stack.m_41783_().m_128457_("DeathX");
            Z = stack.m_41783_().m_128457_("DeathZ");
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Difficulty")) {
            difficulty = stack.m_41783_().m_128451_("Difficulty");
        }
        X = rand.nextDouble(X - (double)range, X + (double)range);
        Z = rand.nextDouble(Z - (double)range, Z + (double)range);
        Y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
        int chunkX = (int)(X / 16.0);
        int chunkZ = (int)(Z / 16.0);
        if (!level.f_46443_) {
            level.m_6325_(chunkX, chunkZ);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (this.taskType.equals("treasure_map") || this.taskType.equals("random_task") && randomValue < (double)0.67f) {
                Y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
                this.summonTreasure(X, Y, Z, player, level, random);
            } else if (this.taskType.equals("skeleton_crew") || this.taskType.equals("random_task") && randomValue < 1.0) {
                BlockPos pos = new BlockPos((int)X, (int)Y, (int)Z);
                for (int i = 0; i < 100; ++i) {
                    boolean isInWater;
                    boolean bl = isInWater = level.m_8055_(pos).m_60734_().equals(Blocks.f_49990_) || level.m_8055_(pos).m_60734_().equals(Blocks.f_50037_) || level.m_8055_(pos).m_60734_().equals(Blocks.f_50038_) || level.m_8055_(pos).m_60734_().equals(Blocks.f_50576_);
                    if (!isInWater) break;
                    X = player.m_20185_();
                    Z = player.m_20189_();
                    X = rand.nextDouble(X - (double)range, X + (double)range);
                    Z = rand.nextDouble(Z - (double)range, Z + (double)range);
                    Y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
                    pos = new BlockPos((int)X, (int)Y, (int)Z);
                }
                this.summonSkeletonCrewCamp(X, Y, Z, player, level, random, difficulty);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return super.m_7203_(level, player, pUsedHand);
    }

    private void summonSkeletonCrewCamp(double x, double y, double z, Player player, Level level, RandomSource random, int difficulty) {
        if (!level.f_46443_) {
            this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.skeleton_crew", "skeleton_crew");
            SkeletonCrewCamp skeletonCrewCamp = new SkeletonCrewCamp(ModEntities.SKELETON_CREW_CAMP.get(), level, difficulty, 3);
            skeletonCrewCamp.m_6027_(x, y, z);
            level.m_7967_((Entity)skeletonCrewCamp);
        }
    }

    private void summonSkeletonCrew(double x, double y, double z, Player player, Level level, RandomSource random) {
        block10: {
            if (level.f_46443_) break block10;
            Random rand = new Random();
            this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.skeleton_crew", "skeleton_crew");
            int captainsAmount = rand.nextInt(1, 4);
            double randomValue = random.m_188501_();
            if (randomValue < 0.4) {
                Enum variant;
                int i;
                for (i = 0; i < captainsAmount; ++i) {
                    CaptainSkeletonEntity captain = new CaptainSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.CAPTAIN_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                    captain.setCanDropKeysAndOrders(false);
                    captain.m_6593_((Component)Component.m_237113_((String)captain.getRandomName(random)));
                    variant = (CaptainSkeletonVariant)((Object)Util.m_214670_((Object[])CaptainSkeletonVariant.values(), (RandomSource)random));
                    captain.setVariant((CaptainSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
                for (i = 0; i < captainsAmount / 2 + 3; ++i) {
                    TOTDSkeletonEntity pirate = new TOTDSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.TOTD_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                    variant = (TOTDSkeletonVariant)((Object)Util.m_214670_((Object[])TOTDSkeletonVariant.values(), (RandomSource)random));
                    pirate.setVariant((TOTDSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
            } else if (randomValue < 0.7) {
                Enum variant;
                int i;
                for (i = 0; i < captainsAmount; ++i) {
                    CaptainShadowSkeletonEntity captain = new CaptainShadowSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.CAPTAIN_SHADOW_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                    captain.setCanDropKeysAndOrders(false);
                    captain.m_6593_((Component)Component.m_237113_((String)captain.getRandomName(random)));
                    variant = (CaptainShadowSkeletonVariant)((Object)Util.m_214670_((Object[])CaptainShadowSkeletonVariant.values(), (RandomSource)random));
                    captain.setVariant((CaptainShadowSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
                for (i = 0; i < captainsAmount / 2 + 3; ++i) {
                    ShadowSkeletonEntity pirate = new ShadowSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.SHADOW_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                    variant = (ShadowSkeletonVariant)((Object)Util.m_214670_((Object[])ShadowSkeletonVariant.values(), (RandomSource)random));
                    pirate.setVariant((ShadowSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
            } else {
                Enum variant;
                int i;
                for (i = 0; i < captainsAmount; ++i) {
                    CaptainBloomingSkeletonEntity captain = new CaptainBloomingSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.CAPTAIN_BLOOMING_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                    captain.setCanDropKeysAndOrders(false);
                    captain.m_6593_((Component)Component.m_237113_((String)captain.getRandomName(random)));
                    variant = (CaptainBloomingSkeletonVariant)((Object)Util.m_214670_((Object[])CaptainBloomingSkeletonVariant.values(), (RandomSource)random));
                    captain.setVariant((CaptainBloomingSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
                for (i = 0; i < captainsAmount / 2 + 3; ++i) {
                    BloomingSkeletonEntity pirate = new BloomingSkeletonEntity((EntityType<? extends Monster>)((EntityType)ModEntities.BLOOMING_SKELETON.get()), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                    variant = (BloomingSkeletonVariant)((Object)Util.m_214670_((Object[])BloomingSkeletonVariant.values(), (RandomSource)random));
                    pirate.setVariant((BloomingSkeletonVariant)variant);
                    y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)(x += (double)random.m_216339_(-2, 3)), (int)(z += (double)random.m_216339_(-2, 3)));
                }
            }
        }
    }

    private static void newSkeleton(double x, double y, double z, Level level, RandomSource random, TOTDSkeletonEntity skeleton, Random rand) {
        skeleton.m_7678_(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
        skeleton.m_20049_("TOTD_Rotate");
        skeleton.m_21530_();
        level.m_7967_((Entity)skeleton);
        skeleton.populateDefaultEquipmentSlots(random);
    }

    private void summonTreasure(double x, double y, double z, Player player, Level level, RandomSource random) {
        if (!level.f_46443_) {
            Random rand = new Random();
            if ((double)random.m_188501_() < (double)0.9f) {
                TreasureChestEntity treasure = new TreasureChestEntity((EntityType)ModEntities.TREASURE_CHEST.get(), level);
                treasure.m_7678_(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
                treasure.m_20049_("TOTD_Rotate");
                level.m_7967_((Entity)treasure);
                this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.buried_treasure", "treasure_map");
                this.buryTheTreasure((LivingEntity)treasure, level, random);
            } else if ((double)random.m_188501_() < 1.0) {
                VillainousSkullEntity treasure = new VillainousSkullEntity((EntityType)ModEntities.VILLAINOUS_SKULL.get(), level);
                treasure.m_7678_(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
                treasure.m_20049_("TOTD_Rotate");
                level.m_7967_((Entity)treasure);
                this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.buried_treasure", "treasure_map");
                this.buryTheTreasure((LivingEntity)treasure, level, random);
            }
        }
    }

    private void giveMap(double x, double y, double z, Player player, Level level, RandomSource random, String mapName, String decoration) {
        if (!level.f_46443_) {
            ItemStack map = MapItem.m_42886_((Level)level, (int)((int)x), (int)((int)z), (byte)((byte)random.m_216339_(0, 3)), (boolean)true, (boolean)true);
            if (decoration.equals("treasure_map")) {
                MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z), (String)"TREASURE", (MapDecoration.Type)MapDecoration.Type.RED_X);
            } else if (decoration.equals("skeleton_crew")) {
                MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z), (String)"TREASURE", (MapDecoration.Type)MapDecoration.Type.BANNER_BLACK);
            }
            map.m_41714_((Component)Component.m_237115_((String)mapName));
            MapItem.m_42850_((ServerLevel)level.m_7654_().m_129783_(), (ItemStack)map);
            if (player.m_150109_().m_36062_() == -1) {
                ItemEntity mapEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), map);
                level.m_7967_((Entity)mapEntity);
            } else {
                player.m_36356_(map);
            }
        }
    }

    private void buryTheTreasure(LivingEntity treasure, Level level, RandomSource random) {
        boolean isInAirOrInSnow;
        int x = treasure.m_146903_();
        int y = treasure.m_146904_();
        int z = treasure.m_146907_();
        BlockPos pos1 = new BlockPos(x, y, z);
        BlockPos pos2 = new BlockPos(x, y - 1, z);
        boolean isInWater = level.m_8055_(pos1).m_60734_() == Blocks.f_49990_;
        boolean isOnLeaves = level.m_8055_(pos2).m_204336_(BlockTags.f_13035_);
        boolean isOnAir = level.m_8055_(pos2).m_60734_() == Blocks.f_50016_;
        boolean bl = isInAirOrInSnow = level.m_8055_(pos1).m_60734_() == Blocks.f_50016_ || level.m_8055_(pos1).m_60734_() == Blocks.f_50125_;
        if (isInWater) {
            treasure.m_6027_((double)x, (double)y, (double)z);
        }
        while (isOnLeaves || isOnAir) {
            treasure.m_6027_((double)x, (double)(y - 1), (double)z);
            y = treasure.m_146904_();
            pos1 = new BlockPos(x, y, z);
            pos2 = new BlockPos(x, y - 1, z);
            isOnLeaves = level.m_8055_(pos2).m_204336_(BlockTags.f_13035_);
            isOnAir = level.m_8055_(pos2).m_60734_() == Blocks.f_50016_;
        }
        if (isInAirOrInSnow) {
            treasure.m_6027_((double)x, (double)(y - random.m_216339_(1, 4)), (double)z);
            y = treasure.m_146904_();
            pos1 = new BlockPos(x, y, z);
            pos2 = new BlockPos(x, y - 1, z);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        int difficulty = 0;
        if (stack.m_41783_() != null) {
            difficulty = stack.m_41783_().m_128451_("Difficulty");
        }
        if (this.taskType.equals("skeleton_crew")) {
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.treasures_of_the_dead.quest_difficulty.tooltip", (Object[])new Object[]{difficulty}));
        }
    }
}

