/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class BlunderBombExplosionParticles
extends TextureSheetParticle {
    public boolean noFading;

    public BlunderBombExplosionParticles(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        Random rand = new Random();
        float randomValue = rand.nextFloat();
        this.noFading = randomValue > 0.5f;
        this.f_107663_ = 0.025f;
        this.m_108339_(spriteSet);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        if (this.noFading) {
            this.f_107226_ = 4.5f;
            this.f_172258_ = 0.75f;
            this.f_107225_ = 80 + rand.nextInt(0, 20);
        } else {
            this.f_107226_ = 3.5f;
            this.f_172258_ = 0.65f;
            this.f_107225_ = 80;
        }
        float spreed1 = rand.nextFloat(0.95f, 1.05f);
        float spreed2 = rand.nextFloat(0.75f, 0.85f);
        double speedModifier = this.noFading ? (double)spreed1 : (double)spreed2;
        this.f_107215_ += xSpeed * speedModifier;
        this.f_107216_ += ySpeed * speedModifier;
        this.f_107217_ += zSpeed * speedModifier;
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.noFading) {
            if (this.f_107224_ > 4) {
                this.f_172258_ = 0.95f;
                this.f_107226_ = 0.1f;
            }
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    protected int m_6355_(float partialTick) {
        if (this.noFading) {
            return 0xF000F0;
        }
        int fadeStartAge = 6;
        int fadeDuration = 12;
        if (this.f_107224_ < fadeStartAge) {
            return 0xF000F0;
        }
        if (this.f_107224_ < fadeStartAge + fadeDuration) {
            float fadeProgress = ((float)(this.f_107224_ - fadeStartAge) + partialTick) / (float)fadeDuration;
            fadeProgress = Math.min(fadeProgress, 1.0f);
            int lightLevel = 15 - (int)(15.0f * fadeProgress);
            return lightLevel << 20 | lightLevel << 4;
        }
        return 0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new BlunderBombExplosionParticles(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

