/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class NewArmorRenderer<T extends ArmorItem>
extends GeoArmorRenderer<T> {
    protected BakedGeoModel lastModel = null;
    protected GeoBone legs = null;

    public NewArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    @Nullable
    public GeoBone getArmorLegsBone() {
        return this.model.getBone("armorLegs").orElse(null);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)((ArmorItem)this.animatable))));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForBaby(poseStack, (Item)animatable, partialTick, isReRender);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!(this.currentEntity instanceof GeoAnimatable)) {
            this.applyBoneVisibilityBySlot(this.currentSlot);
        }
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel != bakedModel) {
            this.lastModel = bakedModel;
            this.head = this.getHeadBone();
            this.body = this.getBodyBone();
            this.legs = this.getArmorLegsBone();
            this.rightArm = this.getRightArmBone();
            this.leftArm = this.getLeftArmBone();
            this.rightLeg = this.getRightLegBone();
            this.leftLeg = this.getLeftLegBone();
            this.rightBoot = this.getRightBootBone();
            this.leftBoot = this.getLeftBootBone();
        }
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.m_8009_(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, true);
                break;
            }
            case CHEST: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                break;
            }
            case LEGS: {
                this.setBoneVisible(this.legs, true);
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                break;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        this.m_8009_(false);
        currentPart.f_104207_ = true;
        GeoBone bone = null;
        if (currentPart != model.f_102809_ && currentPart != model.f_102808_) {
            if (currentPart == model.f_102810_) {
                bone = currentSlot == EquipmentSlot.LEGS ? this.legs : this.body;
            } else if (currentPart == model.f_102812_) {
                bone = this.leftArm;
            } else if (currentPart == model.f_102811_) {
                bone = this.rightArm;
            } else if (currentPart == model.f_102814_) {
                bone = currentSlot == EquipmentSlot.FEET ? this.leftBoot : this.leftLeg;
            } else if (currentPart == model.f_102813_) {
                bone = currentSlot == EquipmentSlot.FEET ? this.rightBoot : this.rightLeg;
            }
        } else {
            bone = this.head;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        ModelPart leftLegPart;
        if (this.head != null) {
            leftLegPart = baseModel.f_102808_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.head);
            this.head.updatePosition(leftLegPart.f_104200_, -leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
        if (this.body != null) {
            leftLegPart = baseModel.f_102810_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.body);
            this.body.updatePosition(leftLegPart.f_104200_, -leftLegPart.f_104201_, leftLegPart.f_104202_);
            if (this.legs != null) {
                RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.legs);
                this.legs.updatePosition(leftLegPart.f_104200_, -leftLegPart.f_104201_, leftLegPart.f_104202_);
            }
        }
        if (this.rightArm != null) {
            leftLegPart = baseModel.f_102811_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.rightArm);
            this.rightArm.updatePosition(leftLegPart.f_104200_ + 5.0f, 2.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
        if (this.leftArm != null) {
            leftLegPart = baseModel.f_102812_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftArm);
            this.leftArm.updatePosition(leftLegPart.f_104200_ - 5.0f, 2.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
        if (this.rightLeg != null) {
            leftLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.rightLeg);
            this.rightLeg.updatePosition(leftLegPart.f_104200_ + 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.rightBoot);
                this.rightBoot.updatePosition(leftLegPart.f_104200_ + 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            }
        }
        if (this.leftLeg != null) {
            leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            }
        }
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        this.setBoneVisible(this.legs, pVisible);
    }
}

