/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead;

import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="treasures_of_the_dead", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    private static final ModConfigSpec.IntValue RANDOM_ADVENTURE_ITEM_DISTANCE_IN_CHUNKS;
    private static final ModConfigSpec.ConfigValue<String> CAPTAIN_NAMES_LANG;
    private static final ModConfigSpec.ConfigValue<Double> PIRATE_SKELETON_HEALTH;
    private static final ModConfigSpec.ConfigValue<Double> PIRATE_SKELETON_DAMAGE;
    private static final ModConfigSpec.ConfigValue<Double> CAPTAIN_SKELETON_HEALTH;
    private static final ModConfigSpec.ConfigValue<Double> CAPTAIN_SKELETON_DAMAGE;
    public static Set<Item> items;
    public static int randomAdventureItemDistanceInChunks;
    public static String captainNamesLang;
    public static double pirateSkeletonHealth;
    public static double pirateSkeletonDamage;
    public static double captainSkeletonHealth;
    public static double captainSkeletonDamage;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        randomAdventureItemDistanceInChunks = (Integer)RANDOM_ADVENTURE_ITEM_DISTANCE_IN_CHUNKS.get();
        captainNamesLang = (String)CAPTAIN_NAMES_LANG.get();
        pirateSkeletonHealth = (Double)PIRATE_SKELETON_HEALTH.get();
        pirateSkeletonDamage = (Double)PIRATE_SKELETON_DAMAGE.get();
        captainSkeletonHealth = (Double)CAPTAIN_SKELETON_HEALTH.get();
        captainSkeletonDamage = (Double)CAPTAIN_SKELETON_DAMAGE.get();
    }

    static {
        BUILDER.push("Treasures of the dead - Common Config!");
        RANDOM_ADVENTURE_ITEM_DISTANCE_IN_CHUNKS = BUILDER.comment("For big adventures you can set this parameter to your distance of view. (if the value of this parameter is higher than your distance of view, than buried treasures and skeletons will spawning in bedrock)").defineInRange("randomAdventureItemDistanceInChunks", 8, 6, 128);
        CAPTAIN_NAMES_LANG = BUILDER.comment("(For servers) For now you can use only ru_ru or en_us").define("captain_names_lang", (Object)"en_us");
        BUILDER.comment("ALL BELOW IS NOT WORKING FOR NOW!");
        PIRATE_SKELETON_HEALTH = BUILDER.define("pirateSkeletonHealth", (Object)26.0);
        PIRATE_SKELETON_DAMAGE = BUILDER.define("pirateSkeletonDamage", (Object)3.0);
        CAPTAIN_SKELETON_HEALTH = BUILDER.define("captainSkeletonHealth", (Object)70.0);
        CAPTAIN_SKELETON_DAMAGE = BUILDER.define("captainSkeletonDamage", (Object)4.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

