/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;

public class TOTDUtils {
    public static Map<String, Integer> loadMinMaxParameterFromJson(Entity thisEntity, String JsonPath, String parameter) {
        HashMap<String, Integer> configs = new HashMap<String, Integer>();
        Level level = thisEntity.level();
        if (!(level instanceof ServerLevel)) {
            return configs;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        ResourceManager resourceManager = serverlevel.getServer().getResourceManager();
        ResourceLocation configLocation = Treasures_of_the_dead.resource(JsonPath);
        try {
            Resource resource = (Resource)resourceManager.getResource(configLocation).orElseThrow();
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(resource.open())).getAsJsonObject();
            JsonElement minMax = json.get(parameter);
            if (minMax != null && minMax.isJsonObject()) {
                JsonObject obj = minMax.getAsJsonObject();
                int min = obj.get("min").getAsInt();
                int max = obj.get("max").getAsInt();
                configs.put("min", min);
                configs.put("max", max);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading JSON for " + String.valueOf(configLocation) + ":" + e.getMessage());
        }
        return configs;
    }

    public static int loadIntParameterFromJson(Entity thisEntity, String JsonPath, String parameter) {
        int configs = 0;
        Level level = thisEntity.level();
        if (!(level instanceof ServerLevel)) {
            return configs;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        ResourceManager resourceManager = serverlevel.getServer().getResourceManager();
        ResourceLocation configLocation = Treasures_of_the_dead.resource(JsonPath);
        try {
            Resource resource = (Resource)resourceManager.getResource(configLocation).orElseThrow();
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(resource.open())).getAsJsonObject();
            JsonElement value = json.get(parameter);
            if (value != null) {
                configs = value.getAsInt();
            }
        }
        catch (Exception e) {
            System.err.println("Error loading JSON for " + String.valueOf(configLocation) + ":" + e.getMessage());
        }
        return configs;
    }
}

