/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.entity.client.CaptainBloomingSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainBloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainBloomingSkeletonVariant;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class CaptainBloomingSkeletonRenderer
extends GeoEntityRenderer<CaptainBloomingSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<CaptainBloomingSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CaptainBloomingSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainBloomingSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton1.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR1, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton1.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR2, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton2.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR3, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton2.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR4, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton3.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR5, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton3.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR6, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton1.png"));
        p_114874_.put(CaptainBloomingSkeletonVariant.VAR7, Treasures_of_the_dead.resource("textures/entity/blooming_skeleton2.png"));
    });

    public CaptainBloomingSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CaptainBloomingSkeletonModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<CaptainBloomingSkeletonEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, CaptainBloomingSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainBloomingSkeletonRenderer.LEFT_BOOT, CaptainBloomingSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case CaptainBloomingSkeletonRenderer.LEFT_ARMOR_LEG, CaptainBloomingSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainBloomingSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case CaptainBloomingSkeletonRenderer.CHESTPLATE, CaptainBloomingSkeletonRenderer.RIGHT_SLEEVE, CaptainBloomingSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case CaptainBloomingSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, CaptainBloomingSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainBloomingSkeletonRenderer.LEFT_BOOT, CaptainBloomingSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case CaptainBloomingSkeletonRenderer.LEFT_ARMOR_LEG, CaptainBloomingSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainBloomingSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case CaptainBloomingSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case CaptainBloomingSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case CaptainBloomingSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case CaptainBloomingSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, CaptainBloomingSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case CaptainBloomingSkeletonRenderer.LEFT_BOOT, CaptainBloomingSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.leftLeg;
                    case CaptainBloomingSkeletonRenderer.RIGHT_BOOT, CaptainBloomingSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.rightLeg;
                    case CaptainBloomingSkeletonRenderer.RIGHT_SLEEVE -> baseModel.rightArm;
                    case CaptainBloomingSkeletonRenderer.LEFT_SLEEVE -> baseModel.leftArm;
                    case CaptainBloomingSkeletonRenderer.CHESTPLATE, CaptainBloomingSkeletonRenderer.CHEST_LEGGINGS -> baseModel.body;
                    case CaptainBloomingSkeletonRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<CaptainBloomingSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, CaptainBloomingSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainBloomingSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainBloomingSkeletonRenderer.this.mainHandItem;
                        }
                        yield CaptainBloomingSkeletonRenderer.this.offhandItem;
                    }
                    case CaptainBloomingSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainBloomingSkeletonRenderer.this.offhandItem;
                        }
                        yield CaptainBloomingSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, CaptainBloomingSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainBloomingSkeletonRenderer.LEFT_HAND, CaptainBloomingSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, CaptainBloomingSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == CaptainBloomingSkeletonRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == CaptainBloomingSkeletonRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(CaptainBloomingSkeletonEntity instance) {
        return LOCATION_BY_VARIANT.get((Object)instance.getCaptainBloomingVariant());
    }

    public void preRender(PoseStack poseStack, CaptainBloomingSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void render(CaptainBloomingSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

