/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.entity.client.CaptainGoldenSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainGoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainGoldenSkeletonVariant;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class CaptainGoldenSkeletonRenderer
extends GeoEntityRenderer<CaptainGoldenSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<CaptainGoldenSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CaptainGoldenSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainGoldenSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("textures/entity/captain_golden_skeleton1.png"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR1, Treasures_of_the_dead.resource("textures/entity/golden_skeleton2.png"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR2, Treasures_of_the_dead.resource("textures/entity/golden_skeleton3.png"));
    });
    public static final Map<CaptainGoldenSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT_RUSTED = (Map)Util.make((Object)Maps.newEnumMap(CaptainGoldenSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainGoldenSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("textures/entity/rusted_captain_golden_skeleton1.png"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR1, Treasures_of_the_dead.resource("textures/entity/rusted_golden_skeleton2.png"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR2, Treasures_of_the_dead.resource("textures/entity/rusted_golden_skeleton3.png"));
    });
    public static final Map<CaptainGoldenSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT_MODEL = (Map)Util.make((Object)Maps.newEnumMap(CaptainGoldenSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainGoldenSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("geo/captain_golden_skeleton1.geo.json"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR1, Treasures_of_the_dead.resource("geo/golden_skeleton.geo.json"));
        p_114874_.put(CaptainGoldenSkeletonVariant.VAR2, Treasures_of_the_dead.resource("geo/golden_skeleton.geo.json"));
    });

    public CaptainGoldenSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CaptainGoldenSkeletonModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<CaptainGoldenSkeletonEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, CaptainGoldenSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainGoldenSkeletonRenderer.LEFT_BOOT, CaptainGoldenSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case CaptainGoldenSkeletonRenderer.LEFT_ARMOR_LEG, CaptainGoldenSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainGoldenSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case CaptainGoldenSkeletonRenderer.CHESTPLATE, CaptainGoldenSkeletonRenderer.RIGHT_SLEEVE, CaptainGoldenSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case CaptainGoldenSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, CaptainGoldenSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainGoldenSkeletonRenderer.LEFT_BOOT, CaptainGoldenSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case CaptainGoldenSkeletonRenderer.LEFT_ARMOR_LEG, CaptainGoldenSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainGoldenSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case CaptainGoldenSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case CaptainGoldenSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case CaptainGoldenSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case CaptainGoldenSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, CaptainGoldenSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case CaptainGoldenSkeletonRenderer.LEFT_BOOT, CaptainGoldenSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.leftLeg;
                    case CaptainGoldenSkeletonRenderer.RIGHT_BOOT, CaptainGoldenSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.rightLeg;
                    case CaptainGoldenSkeletonRenderer.RIGHT_SLEEVE -> baseModel.rightArm;
                    case CaptainGoldenSkeletonRenderer.LEFT_SLEEVE -> baseModel.leftArm;
                    case CaptainGoldenSkeletonRenderer.CHESTPLATE, CaptainGoldenSkeletonRenderer.CHEST_LEGGINGS -> baseModel.body;
                    case CaptainGoldenSkeletonRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<CaptainGoldenSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, CaptainGoldenSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainGoldenSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainGoldenSkeletonRenderer.this.mainHandItem;
                        }
                        yield CaptainGoldenSkeletonRenderer.this.offhandItem;
                    }
                    case CaptainGoldenSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainGoldenSkeletonRenderer.this.offhandItem;
                        }
                        yield CaptainGoldenSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, CaptainGoldenSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainGoldenSkeletonRenderer.LEFT_HAND, CaptainGoldenSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, CaptainGoldenSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == CaptainGoldenSkeletonRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == CaptainGoldenSkeletonRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(CaptainGoldenSkeletonEntity entity) {
        if (entity.getIsRusted()) {
            return LOCATION_BY_VARIANT_RUSTED.get((Object)entity.getCaptainGoldenVariant());
        }
        return LOCATION_BY_VARIANT.get((Object)entity.getCaptainGoldenVariant());
    }

    public void preRender(PoseStack poseStack, CaptainGoldenSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void render(CaptainGoldenSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

