/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.entity.client.ShadowSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.client.ShadowSkeletonRenderLayer;
import net.mrwilfis.treasures_of_the_dead.entity.custom.ShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.ShadowSkeletonVariant;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class ShadowSkeletonRenderer
extends GeoEntityRenderer<ShadowSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<ShadowSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(ShadowSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(ShadowSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton1.png"));
        p_114874_.put(ShadowSkeletonVariant.VAR1, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton2.png"));
        p_114874_.put(ShadowSkeletonVariant.VAR2, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton3.png"));
        p_114874_.put(ShadowSkeletonVariant.VAR3, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton4.png"));
        p_114874_.put(ShadowSkeletonVariant.VAR4, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton5.png"));
        p_114874_.put(ShadowSkeletonVariant.VAR5, Treasures_of_the_dead.resource("textures/entity/shadow_skeleton6.png"));
    });

    public ShadowSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new ShadowSkeletonModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer(new ShadowSkeletonRenderLayer(this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<ShadowSkeletonEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, ShadowSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case ShadowSkeletonRenderer.LEFT_BOOT, ShadowSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case ShadowSkeletonRenderer.LEFT_ARMOR_LEG, ShadowSkeletonRenderer.RIGHT_ARMOR_LEG, ShadowSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case ShadowSkeletonRenderer.CHESTPLATE, ShadowSkeletonRenderer.RIGHT_SLEEVE, ShadowSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case ShadowSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, ShadowSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case ShadowSkeletonRenderer.LEFT_BOOT, ShadowSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case ShadowSkeletonRenderer.LEFT_ARMOR_LEG, ShadowSkeletonRenderer.RIGHT_ARMOR_LEG, ShadowSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case ShadowSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case ShadowSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case ShadowSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case ShadowSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, ShadowSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case ShadowSkeletonRenderer.LEFT_BOOT, ShadowSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.leftLeg;
                    case ShadowSkeletonRenderer.RIGHT_BOOT, ShadowSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.rightLeg;
                    case ShadowSkeletonRenderer.RIGHT_SLEEVE -> baseModel.rightArm;
                    case ShadowSkeletonRenderer.LEFT_SLEEVE -> baseModel.leftArm;
                    case ShadowSkeletonRenderer.CHESTPLATE, ShadowSkeletonRenderer.CHEST_LEGGINGS -> baseModel.body;
                    case ShadowSkeletonRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<ShadowSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, ShadowSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case ShadowSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield ShadowSkeletonRenderer.this.mainHandItem;
                        }
                        yield ShadowSkeletonRenderer.this.offhandItem;
                    }
                    case ShadowSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield ShadowSkeletonRenderer.this.offhandItem;
                        }
                        yield ShadowSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, ShadowSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case ShadowSkeletonRenderer.LEFT_HAND, ShadowSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, ShadowSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == ShadowSkeletonRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == ShadowSkeletonRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(ShadowSkeletonEntity instance) {
        return LOCATION_BY_VARIANT.get((Object)instance.getShadowVariant());
    }

    public void preRender(PoseStack poseStack, ShadowSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void render(ShadowSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

