/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.custom.AnyTreasureClass;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BlunderBombEntity;
import org.jetbrains.annotations.NotNull;

public class AbstractPowderKegEntity
extends AnyTreasureClass {
    private static final EntityDataAccessor<Boolean> IS_GOING_TO_BLOW_UP = SynchedEntityData.defineId(AbstractPowderKegEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PREPARE_TO_BLOW_UP = SynchedEntityData.defineId(AbstractPowderKegEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int maxPrepareToBlowUp;
    public float explodeRadius;

    public AbstractPowderKegEntity(EntityType pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
        this.maxPrepareToBlowUp = this.getMaxPrepareToBlowUp();
        this.explodeRadius = this.getExplodeRadius();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0).build();
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        if (!pPlayer.isShiftKeyDown()) {
            boolean b = this.getIsGoingToBlowUp();
            if (!b) {
                this.setIsGoingToBlowUp(true);
                return InteractionResult.SUCCESS;
            }
            this.setIsGoingToBlowUp(false);
            return InteractionResult.SUCCESS;
        }
        this.setYRot(pPlayer.getYRot() - 180.0f);
        this.addTag("TOTD_Rotate");
        return super.mobInteract(pPlayer, pHand);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            boolean b = this.getIsGoingToBlowUp();
            int i = this.getPrepareToBlowUp();
            if (b) {
                this.setPrepareToBlowUp(i + 1);
            } else if (i != 0) {
                this.setPrepareToBlowUp(0);
            }
            if (i >= this.maxPrepareToBlowUp) {
                this.explodeKeg();
            }
            if (b && i == 0) {
                this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 0.5f);
            }
        }
        if (this.getIsGoingToBlowUp()) {
            this.createFuseParticles(this.level(), this.random, this.position());
        }
    }

    protected void explodeKeg() {
        if (!this.level().isClientSide) {
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.explodeRadius, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, Vec3 position) {
        double xOffset = this.random.nextDouble() * 0.2 - 0.1;
        double yOffset = this.random.nextDouble() * 0.2 - 0.1;
        double zOffset = this.random.nextDouble() * 0.2 - 0.1;
        double xSpeed = this.random.nextDouble() * 0.04 - 0.02;
        double ySpeed = this.random.nextDouble() * 0.05 + 0.03;
        double zSpeed = this.random.nextDouble() * 0.04 - 0.02;
        try {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, position.x + xOffset, position.y + yOffset + 0.665, position.z + zOffset, xSpeed, ySpeed, zSpeed);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public boolean isInvulnerableTo(DamageSource pSource) {
        return pSource.is(DamageTypes.IN_WALL) || pSource.is(DamageTypes.FALLING_BLOCK) || pSource.is(DamageTypes.CACTUS) || pSource.is(DamageTypes.DRAGON_BREATH) || pSource.is(DamageTypes.FREEZE) || pSource.is(DamageTypes.INDIRECT_MAGIC) || pSource.is(DamageTypes.EXPLOSION) || pSource.is(DamageTypes.PLAYER_EXPLOSION) || pSource.is(DamageTypes.ON_FIRE) || pSource.is(DamageTypes.HOT_FLOOR) || pSource.is(DamageTypes.LAVA);
    }

    @Override
    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        boolean fastExplosion = pSource.is(DamageTypes.FALLING_ANVIL) || pSource.is(DamageTypes.FALLING_STALACTITE) || pSource.is(DamageTypes.FIREWORKS) || pSource.is(DamageTypes.LIGHTNING_BOLT) || pSource.is(DamageTypes.ARROW) || pSource.is(DamageTypes.FIREBALL) || pSource.is(DamageTypes.UNATTRIBUTED_FIREBALL) || pSource.is(DamageTypes.TRIDENT) || pSource.is(DamageTypes.MOB_PROJECTILE) || pSource.is(DamageTypes.SONIC_BOOM);
        boolean slowExplosion = pSource.is(DamageTypes.LAVA) || pSource.is(DamageTypes.HOT_FLOOR) || pSource.is(DamageTypes.ON_FIRE);
        boolean isSourceExplosion = pSource.is(DamageTypes.PLAYER_EXPLOSION) || pSource.is(DamageTypes.EXPLOSION);
        boolean isBlunderBomb = pSource.getDirectEntity() instanceof BlunderBombEntity;
        if (fastExplosion) {
            this.explodeKeg();
        } else if (isSourceExplosion && !isBlunderBomb) {
            if (pAmount > 30.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 1);
            } else if (pAmount > 16.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 20);
            }
            this.setIsGoingToBlowUp(true);
        } else if (isSourceExplosion && isBlunderBomb) {
            if (pAmount > 9.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 1);
            } else if (pAmount > 5.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 20);
            }
            this.setIsGoingToBlowUp(true);
        } else if (slowExplosion) {
            this.setIsGoingToBlowUp(true);
        } else if (!this.isInvulnerableTo(pSource)) {
            this.turnIntoItem();
        }
        return super.hurt(pSource, pAmount);
    }

    public int getMaxPrepareToBlowUp() {
        return 90;
    }

    public float getExplodeRadius() {
        return 3.0f;
    }

    public boolean getIsGoingToBlowUp() {
        return (Boolean)this.getEntityData().get(IS_GOING_TO_BLOW_UP);
    }

    public void setIsGoingToBlowUp(boolean b) {
        this.getEntityData().set(IS_GOING_TO_BLOW_UP, (Object)b);
    }

    public int getPrepareToBlowUp() {
        return (Integer)this.getEntityData().get(PREPARE_TO_BLOW_UP);
    }

    public void setPrepareToBlowUp(int i) {
        this.getEntityData().set(PREPARE_TO_BLOW_UP, (Object)i);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPrepareToBlowUp(tag.getInt("PrepareToBlowUp"));
        this.setIsGoingToBlowUp(tag.getBoolean("IsGoingToBlowUp"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("PrepareToBlowUp", this.getPrepareToBlowUp());
        tag.putBoolean("IsGoingToBlowUp", this.getIsGoingToBlowUp());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PREPARE_TO_BLOW_UP, (Object)0);
        builder.define(IS_GOING_TO_BLOW_UP, (Object)false);
    }
}

