/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;

public class BulletEntity
extends AbstractHurtingProjectile
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> INITIAL_SPEED = SynchedEntityData.defineId(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> DROP_REDUCTION = SynchedEntityData.defineId(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Byte> PELLET_COUNT = SynchedEntityData.defineId(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final float BASE_DAMAGE = 4.0f;
    private static final float DAMAGE_MULTIPLIER = 0.5f;
    private static final int MAX_LIFETIME = 100;
    private static final double WATER_FRICTION = 0.6;
    private static final double AIR_FRICTION = 0.99;
    private static final double GRAVITY = 0.05;
    private static final float MAX_DISTANCE = 250.0f;
    private static final float WATER_SLOWDOWN = 0.8f;
    private static final float MIN_SPEED_THRESHOLD = 0.1f;
    private float distanceTraveled = 0.0f;
    private Vec3 initialPosition;
    private boolean inWater = false;
    private boolean touchedWater;
    private float damage;
    private float distanceTravelled;

    public BulletEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public float calculateEnergyFraction() {
        double energy;
        double maxEnergy = Math.pow(((Float)this.entityData.get(INITIAL_SPEED)).floatValue(), 2.0);
        if (maxEnergy < (energy = this.getDeltaMovement().lengthSqr())) {
            maxEnergy = energy;
        }
        return (float)(energy / maxEnergy);
    }

    public void tick() {
        EntityHitResult entityHitResult;
        BlockHitResult hitResult;
        super.tick();
        if (this.tickCount > 100) {
            this.discard();
            System.out.println("DISCARD 1");
        }
        Level level = this.level();
        Vec3 velocity = this.getDeltaMovement();
        Vec3 from = this.position();
        Vec3 to = from.add(velocity);
        Vec3 waterPos = Vec3.ZERO;
        this.wasTouchingWater = this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.0);
        if (this.wasTouchingWater) {
            waterPos = from;
            velocity = velocity.scale(0.6);
            to = from.add(velocity);
            this.setDeltaMovement(velocity);
        }
        if ((hitResult = level.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).getType() != HitResult.Type.MISS) {
            to = hitResult.getLocation();
        }
        if ((entityHitResult = this.findHitEntity(from, to)) != null) {
            hitResult = entityHitResult;
            to = hitResult.getLocation();
        }
        if (!this.wasTouchingWater) {
            BlockHitResult fluidHitResult = level.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
            if (fluidHitResult.getType() == HitResult.Type.BLOCK) {
                FluidState fluid = level.getFluidState(fluidHitResult.getBlockPos());
                double distanceToFluid = fluidHitResult.getLocation().subtract(from).length();
                double distanceToHit = to.subtract(from).length();
                if (fluid.is(FluidTags.WATER)) {
                    this.wasTouchingWater = true;
                    waterPos = fluidHitResult.getLocation();
                    double speed = velocity.length();
                    double timeInWater = 1.0 - distanceToFluid / speed;
                    double newSpeed = speed * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                    if (hitResult.getType() != HitResult.Type.MISS) {
                        if (distanceToFluid < distanceToHit) {
                            if (distanceToHit < newSpeed) {
                                timeInWater = (distanceToHit - distanceToFluid) / speed;
                                newSpeed = speed * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                            } else {
                                hitResult = BlockHitResult.miss(null, null, null);
                            }
                        } else {
                            fluidHitResult = BlockHitResult.miss(null, null, null);
                        }
                    }
                    velocity = velocity.scale(newSpeed / speed);
                    to = from.add(velocity);
                    this.setDeltaMovement(velocity);
                    if (level.isClientSide && fluidHitResult.getType() != HitResult.Type.MISS) {
                        double d = fluidHitResult.getDirection() == Direction.UP ? 0.02 : 0.0;
                    }
                } else if (fluid.is(FluidTags.LAVA) && (hitResult.getType() == HitResult.Type.MISS || distanceToFluid < distanceToHit)) {
                    hitResult = fluidHitResult;
                    to = fluidHitResult.getLocation();
                }
            }
            if (this.wasTouchingWater) {
                this.touchedWater = true;
                this.extinguishFire();
            }
            if (!level.isClientSide) {
                this.setSharedFlagOnFire(this.getRemainingFireTicks() > 0);
            }
            if (hitResult.getType() != HitResult.Type.MISS) {
                if (this.touchedWater) {
                    this.damage *= this.calculateEnergyFraction();
                }
                if (!level.isClientSide) {
                    this.onHit((HitResult)hitResult);
                    if (hitResult.getType() == HitResult.Type.BLOCK) {
                        this.tickCount = 100;
                    }
                } else if (level.isClientSide && !this.wasTouchingWater) {
                    double length = velocity.length();
                    Vec3 dir = velocity.scale(1.0 / length);
                    float volume = this.calculateEnergyFraction();
                    AABB aabbSelection = this.getBoundingBox().expandTowards(velocity).inflate(8.0);
                    Predicate<Entity> predicate = entity -> entity instanceof Player && !entity.equals((Object)this.getOwner());
                    for (Entity entity2 : this.level().getEntities((Entity)this, aabbSelection, predicate)) {
                        Vec3 pos = new Vec3(entity2.getX(), entity2.getEyeY(), entity2.getZ());
                        Vec3 diff = pos.subtract(from);
                        double proj = dir.dot(diff);
                        if (!(proj > 0.0) || !(proj < length)) continue;
                        Vec3 vec3 = from.add(dir.scale(proj));
                    }
                }
                if (level.isClientSide && this.wasTouchingWater) {
                    double length;
                    Vec3 step = velocity.scale(1.0 / length);
                    Vec3 pos = waterPos.add(step.scale(0.5));
                    float prob = 1.5f * this.calculateEnergyFraction();
                    for (length = velocity.length(); length > 0.5; length -= 1.0) {
                        pos = pos.add(step);
                        if (!(this.random.nextFloat() < prob)) continue;
                        level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.wasTouchingWater) {
                    velocity = velocity.scale(0.99);
                }
                double gravity = 0.05 * (double)(1.0f - ((Float)this.entityData.get(DROP_REDUCTION)).floatValue());
                this.setDeltaMovement(velocity.subtract(0.0, gravity, 0.0));
                this.setPos(to);
                this.distanceTravelled = (float)((double)this.distanceTravelled + to.subtract(from).length());
                this.checkInsideBlocks();
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide && result.getType() == HitResult.Type.ENTITY) {
            float speed = (float)this.getDeltaMovement().length();
            float damage = this.damage + speed * 0.5f;
            Entity entity = result.getEntity();
            Entity shooter = this.getOwner();
            entity.hurt(entity.damageSources().mobProjectile((Entity)this, (LivingEntity)shooter), damage);
            System.out.println("DAMAGE: " + damage);
            this.discard();
            System.out.println("DISCARD by hit");
        }
    }

    public EntityHitResult findHitEntity(Vec3 start, Vec3 end) {
        Entity resultEntity = null;
        Vec3 resultPos = null;
        double resultDist = 0.0;
        AABB aabbSelection = this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.5);
        for (Entity entity : this.level().getEntities((Entity)this, aabbSelection, x$0 -> this.canHitEntity((Entity)x$0))) {
            double dist;
            AABB aabb = entity.getBoundingBox();
            Optional clipResult = aabb.clip(start, end);
            if (!clipResult.isPresent()) {
                aabb = aabb.move(entity.xOld - entity.getX(), entity.yOld - entity.getY(), entity.zOld - entity.getZ());
                clipResult = aabb.clip(start, end);
            }
            if (!clipResult.isPresent() || !((dist = start.distanceToSqr((Vec3)clipResult.get())) < resultDist) && resultEntity != null) continue;
            resultEntity = entity;
            resultPos = (Vec3)clipResult.get();
            resultDist = dist;
        }
        return resultEntity != null ? new EntityHitResult(resultEntity, resultPos) : null;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
        System.out.println("DISCARD 4 (on block hit)");
    }

    public void setVelocity(float bulletSpeed, Vec3 direction) {
        float tickSpeed = bulletSpeed / 20.0f;
        this.setDeltaMovement(direction.scale((double)tickSpeed));
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INITIAL_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(DROP_REDUCTION, (Object)Float.valueOf(0.0f));
        builder.define(PELLET_COUNT, (Object)1);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
        this.distanceTravelled = compound.getFloat("distanceTravelled");
        this.entityData.set(DROP_REDUCTION, (Object)Float.valueOf(compound.getFloat("dropReduction")));
        this.entityData.set(PELLET_COUNT, (Object)compound.getByte("pelletCount"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("damage", this.damage);
        compound.putFloat("distanceTravelled", this.distanceTravelled);
        compound.putFloat("dropReduction", ((Float)this.entityData.get(DROP_REDUCTION)).floatValue());
        compound.putByte("pelletCount", ((Byte)this.entityData.get(PELLET_COUNT)).byteValue());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return ((Entity)object).tickCount;
    }
}

