/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonInterface;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainBloomingSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class CaptainBloomingSkeletonEntity
extends BloomingSkeletonEntity
implements CaptainSkeletonInterface {
    private static final EntityDataAccessor<Float> DEATH_X = SynchedEntityData.defineId(CaptainBloomingSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DEATH_Z = SynchedEntityData.defineId(CaptainBloomingSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> CAN_DROP_KEYS_AND_ORDERS = SynchedEntityData.defineId(CaptainBloomingSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(CaptainBloomingSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CaptainBloomingSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    @Override
    public void specialProcedures() {
        CaptainBloomingSkeletonVariant variant = (CaptainBloomingSkeletonVariant)((Object)Util.getRandom((Object[])CaptainBloomingSkeletonVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.random);
        this.setCustomName((Component)Component.literal((String)this.getRandomName(this.random)));
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 70.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.65f).add(Attributes.MOVEMENT_SPEED, (double)0.24f).build();
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource pSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(level, pSource, pRecentlyHit);
        if (this.getCanDropKeysAndOrders()) {
            double randomValue = this.random.nextFloat();
            if (randomValue < (double)0.4f) {
                this.setDeathX((float)this.getX());
                this.setDeathZ((float)this.getZ());
                ItemStack stack = new ItemStack((ItemLike)ModItems.SKELETONS_ORDER.get());
                stack.set(ModDataComponents.CAPTAIN_SKELETON_DEATH_X, (Object)Float.valueOf(this.getDeathX()));
                stack.set(ModDataComponents.CAPTAIN_SKELETON_DEATH_Z, (Object)Float.valueOf(this.getDeathZ()));
                ItemEntity itemEntity = this.spawnAtLocation(stack);
            } else if (randomValue < (double)0.6f) {
                this.setDeathX((float)this.getX());
                this.setDeathZ((float)this.getZ());
                ItemStack stack = new ItemStack((ItemLike)ModItems.SKELETON_CREW_ASSIGNMENT.get());
                stack.set(ModDataComponents.CAPTAIN_SKELETON_DEATH_X, (Object)Float.valueOf(this.getDeathX()));
                stack.set(ModDataComponents.CAPTAIN_SKELETON_DEATH_Z, (Object)Float.valueOf(this.getDeathZ()));
                stack.set(ModDataComponents.DIFFICULTY, (Object)this.random.nextInt(1, 3));
                ItemEntity itemEntity = this.spawnAtLocation(stack);
            } else {
                ItemEntity itemEntity = this.spawnAtLocation((ItemLike)ModItems.TREASURE_KEY.get());
            }
        }
    }

    @Override
    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.random.nextFloat();
        if (randomValue < 0.1) {
            if ((double)this.random.nextFloat() < 0.3) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.random.nextFloat() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 1.0);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.5);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLACK_VEST.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_PANTS.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.8f);
        } else if (randomValue < 0.55) {
            if ((double)this.random.nextFloat() < 0.1) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.random.nextFloat() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 0.92f);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.08f);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.CAPTAIN_JACKET.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_PANTS.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.5);
        } else if (randomValue < 1.0) {
            if ((double)this.random.nextFloat() < 0.1) {
                this.spawnRandomBandanas(pRandom);
            } else if ((double)this.random.nextFloat() < 1.0) {
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.CAPTAIN_HAT.get()), pRandom, 0.92f);
                this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BICORN.get()), pRandom, 0.08f);
            }
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.CAPTAIN_CROP_VEST.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.CAPTAIN_SKIRT.get()), pRandom, 1.0);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.2f);
        }
        double randomValue2 = this.random.nextFloat();
        if (randomValue2 < 0.8) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD), pRandom, 0.95f);
        } else if (randomValue2 < 0.99) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD), pRandom, 0.95f);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.DIAMOND_SWORD), pRandom, 1.0);
        }
    }

    public CaptainBloomingSkeletonVariant getCaptainBloomingVariant() {
        return CaptainBloomingSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(CaptainBloomingSkeletonVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean getCanDropKeysAndOrders() {
        return (Boolean)this.getEntityData().get(CAN_DROP_KEYS_AND_ORDERS);
    }

    public void setCanDropKeysAndOrders(boolean b) {
        this.getEntityData().set(CAN_DROP_KEYS_AND_ORDERS, (Object)b);
    }

    public float getDeathX() {
        return ((Float)this.getEntityData().get(DEATH_X)).floatValue();
    }

    public void setDeathX(float var) {
        this.getEntityData().set(DEATH_X, (Object)Float.valueOf(var));
    }

    public float getDeathZ() {
        return ((Float)this.getEntityData().get(DEATH_Z)).floatValue();
    }

    public void setDeathZ(float var) {
        this.getEntityData().set(DEATH_Z, (Object)Float.valueOf(var));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
        this.setDeathX(tag.getFloat("DeathX"));
        this.setDeathZ(tag.getFloat("DeathZ"));
        this.setCanDropKeysAndOrders(tag.getBoolean("CanDropKeysAndOrders"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
        tag.putFloat("DeathX", this.getDeathX());
        tag.putFloat("DeathZ", this.getDeathZ());
        tag.putBoolean("CanDropKeysAndOrders", this.getCanDropKeysAndOrders());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(DEATH_X, (Object)Float.valueOf(0.0f));
        builder.define(DEATH_Z, (Object)Float.valueOf(0.0f));
        builder.define(CAN_DROP_KEYS_AND_ORDERS, (Object)true);
    }
}

