/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.variant.TOTDSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TOTDSkeletonEntity
extends Monster
implements GeoAnimatable,
GeoEntity {
    protected int idleVariation;
    private final int maxSpawningTime = 80;
    private int spawningTime;
    private int maxPrepareToBlowUp;
    private int prepareToBlowUp;
    private final AnimatableInstanceCache cache;
    private UUID campUUID;
    private static final double MAX_DISTANCE_FROM_CAMP = 15.0;
    private static final UUID SPEED_MODIFIER_WITH_KEG_UUID = UUID.fromString("d27bb1e7-92bc-4161-8e9d-2f9a52b1598e");
    private static final AttributeModifier SPEED_MODIFIER_WITH_KEG = new AttributeModifier(ResourceLocation.parse((String)SPEED_MODIFIER_WITH_KEG_UUID.toString()), -0.3, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_GOING_TO_BLOW_UP = SynchedEntityData.defineId(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SPAWNING = SynchedEntityData.defineId(TOTDSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final RawAnimation WALK_BODY1 = RawAnimation.begin().then("animation.model.walk_body1", Animation.LoopType.LOOP);
    protected static final RawAnimation WALK_HANDS1 = RawAnimation.begin().then("animation.model.walk_hands1", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE1 = RawAnimation.begin().then("animation.model.idle1", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE2 = RawAnimation.begin().then("animation.model.idle2", Animation.LoopType.LOOP);
    protected static final RawAnimation ATTACK1 = RawAnimation.begin().then("animation.model.attack1", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation SHAKING_FROM_LIGHT = RawAnimation.begin().then("animation.model.shaking_from_light", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation SHAKING_FROM_LIGHT_WITH_KEG = RawAnimation.begin().then("animation.model.shaking_from_light_with_keg", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation WALK_KEG = RawAnimation.begin().then("animation.model.walk_keg", Animation.LoopType.LOOP);
    protected static final RawAnimation IDLE_KEG = RawAnimation.begin().then("animation.model.idle_keg", Animation.LoopType.LOOP);
    protected static final RawAnimation SPAWN2 = RawAnimation.begin().then("animation.model.spawn2", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation RUSTY_TWITCH1 = RawAnimation.begin().then("animation.model.rusty_twitch1", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation RUSTY_TWITCH2 = RawAnimation.begin().then("animation.model.rusty_twitch2", Animation.LoopType.PLAY_ONCE);

    public TOTDSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.idleVariation = this.random.nextInt(1, 3);
        this.maxSpawningTime = 80;
        this.spawningTime = 0;
        this.maxPrepareToBlowUp = 90;
        this.prepareToBlowUp = 0;
        this.cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
        this.campUUID = null;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        boolean b;
        boolean bl = b = pReason.equals((Object)MobSpawnType.SPAWN_EGG) || pReason.equals((Object)MobSpawnType.SPAWNER) || pReason.equals((Object)MobSpawnType.DISPENSER) || pReason.equals((Object)MobSpawnType.MOB_SUMMONED);
        if (!b) {
            this.setIsSpawning(true);
            this.playAmbientSound();
        }
        this.specialProcedures();
        this.populateDefaultEquipmentEnchantments(pLevel, this.random, pDifficulty);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void specialProcedures() {
        TOTDSkeletonVariant variant = (TOTDSkeletonVariant)((Object)Util.getRandom((Object[])TOTDSkeletonVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.random);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 26.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.MOVEMENT_SPEED, (double)0.24f).build();
    }

    public void tick() {
        if (!this.level().isClientSide) {
            ItemStack mainHandItem;
            double distance;
            Entity camp;
            if (this.campUUID != null && (camp = ((ServerLevel)this.level()).getEntity(this.campUUID)) != null && !this.isAggressive() && (distance = (double)this.distanceTo(camp)) > 15.0) {
                this.getNavigation().moveTo(camp.getX(), camp.getY(), camp.getZ(), 1.25);
            }
            if (!(mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND)).isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
                LivingEntity target;
                if (!this.getAttribute(Attributes.MOVEMENT_SPEED).getModifiers().contains(SPEED_MODIFIER_WITH_KEG)) {
                    this.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(SPEED_MODIFIER_WITH_KEG);
                }
                if (this.prepareToBlowUp >= this.maxPrepareToBlowUp) {
                    this.explodeSkeleton();
                }
                if ((target = this.getTarget()) == null) {
                    this.setIsGoingToBlowUp(false);
                } else if (this.distanceToSqr((Entity)target) > 64.0) {
                    this.setIsGoingToBlowUp(false);
                } else if (this.distanceToSqr((Entity)target) < 25.0) {
                    this.setIsGoingToBlowUp(true);
                }
                boolean $$0 = this.getIsGoingToBlowUp();
                if ($$0 && this.prepareToBlowUp == 0) {
                    this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 0.5f);
                }
                this.prepareToBlowUp = $$0 ? ++this.prepareToBlowUp : 0;
            } else if (this.getAttribute(Attributes.MOVEMENT_SPEED).getModifiers().contains(SPEED_MODIFIER_WITH_KEG)) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_WITH_KEG);
            }
            if (this.getIsSpawning()) {
                this.setNoAi(true);
                ++this.spawningTime;
            }
            if (this.spawningTime >= 80) {
                this.setNoAi(false);
                this.setIsSpawning(false);
                this.spawningTime = 0;
            }
        }
        super.tick();
        if (this.getIsGoingToBlowUp()) {
            this.createFuseParticles(this.level(), this.random, this);
        }
    }

    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.random.nextFloat();
        if (randomValue < 0.3) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BOOTS.get()), pRandom, 0.7f);
        } else if (randomValue < 0.6) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLACK_VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.BLACK_PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLACK_BOOTS.get()), pRandom, 0.7f);
        } else if (randomValue < 0.9) {
            this.maybeWearEquipment(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLUE_VEST.get()), pRandom, 0.65f);
            this.maybeWearEquipment(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.BLUE_PANTS.get()), pRandom, 0.5);
            this.maybeWearEquipment(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLUE_BOOTS.get()), pRandom, 0.7f);
        }
        randomValue = this.random.nextFloat();
        if (randomValue < 0.25) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.GREEN_BANDANA.get()), pRandom, 0.6f);
        } else if (randomValue < 0.5) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.RED_BANDANA.get()), pRandom, 0.6f);
        } else if (randomValue < 0.75) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BLUE_BANDANA.get()), pRandom, 0.6f);
        }
        randomValue = this.random.nextFloat();
        if (randomValue < 0.2) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD), pRandom, 0.5);
        } else if (randomValue < 0.95) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD), pRandom, 0.5);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.POWDER_KEG_ITEM.get()), pRandom, 1.0);
        }
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHandItem.getItem() == ModItems.POWDER_KEG_ITEM.get()) {
            this.setLeftHanded(false);
            this.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
        }
    }

    public void spawnRandomBandanas(RandomSource pRandom) {
        double randomValue = this.random.nextFloat();
        if (randomValue < 0.33) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.GREEN_BANDANA.get()), pRandom, 1.0);
        } else if (randomValue < 0.67) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.RED_BANDANA.get()), pRandom, 1.0);
        } else if (randomValue < 1.0) {
            this.maybeWearEquipment(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BLUE_BANDANA.get()), pRandom, 1.0);
        }
    }

    public void maybeWearEquipment(EquipmentSlot pSlot, ItemStack pStack, RandomSource pRandom, double chance) {
        if ((double)pRandom.nextFloat() < chance) {
            this.setItemSlot(pSlot, pStack);
        }
    }

    protected void explodeSkeleton() {
        if (!this.level().isClientSide) {
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, TOTDSkeletonEntity entity) {
        Vec3 entityPos = entity.position();
        float yaw = entity.getYRot();
        double radians = Math.toRadians(yaw);
        Vec3 bodyDirection = new Vec3(-Math.sin(radians), 0.0, Math.cos(radians)).normalize();
        double distance = 0.25;
        Vec3 particlePosition = entityPos.add(bodyDirection.scale(distance));
        double xOffset = random.nextDouble() * 0.2 - 0.1;
        double yOffset = random.nextDouble() * 0.2 - 0.1;
        double zOffset = random.nextDouble() * 0.2 - 0.1;
        double xSpeed = random.nextDouble() * 0.04 - 0.02;
        double ySpeed = random.nextDouble() * 0.06 + 0.03;
        double zSpeed = random.nextDouble() * 0.04 - 0.02;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePosition.x + xOffset, particlePosition.y + yOffset + 1.7, particlePosition.z + zOffset, xSpeed, ySpeed, zSpeed);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TOTDSkeletonEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller1", 3, this::idleAndWalk));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller2", 3, this::walkAndAttack));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller3", 0, this::spawning));
    }

    private PlayState spawning(AnimationState<TOTDSkeletonEntity> state) {
        if (this.getIsSpawning()) {
            state.getController().setAnimation(SPAWN2);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState walkAndAttack(AnimationState<TOTDSkeletonEntity> state) {
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.swinging) {
            state.getController().stop();
            state.getController().setAnimation(ATTACK1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().stop();
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.isAggressive()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !this.swinging) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private PlayState idleAndWalk(AnimationState<TOTDSkeletonEntity> state) {
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (state.isMoving() && this.isAggressive() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.6875);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.35);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(IDLE_KEG);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.isAggressive()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.0);
            if ((double)this.random.nextFloat() < 0.5) {
                this.idleVariation = 1;
            } else if ((double)this.random.nextFloat() < 1.0) {
                this.idleVariation = 2;
            }
            return PlayState.CONTINUE;
        }
        if (!state.isMoving()) {
            if (this.idleVariation == 1) {
                state.getController().setAnimation(IDLE1);
            } else if (this.idleVariation == 2) {
                state.getController().setAnimation(IDLE2);
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public double getTick(Object o) {
        return ((Entity)o).tickCount;
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.SKELETON_STEP;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public void setCampUUID(UUID uuid) {
        this.campUUID = uuid;
    }

    public boolean getIsSpawning() {
        return (Boolean)this.getEntityData().get(IS_SPAWNING);
    }

    public void setIsSpawning(boolean b) {
        this.getEntityData().set(IS_SPAWNING, (Object)b);
    }

    public boolean getIsGoingToBlowUp() {
        return (Boolean)this.getEntityData().get(IS_GOING_TO_BLOW_UP);
    }

    public void setIsGoingToBlowUp(boolean b) {
        this.getEntityData().set(IS_GOING_TO_BLOW_UP, (Object)b);
    }

    public TOTDSkeletonVariant getVariant() {
        return TOTDSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(TOTDSkeletonVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
        this.setIsGoingToBlowUp(tag.getBoolean("IsGoingToBlowUp"));
        this.setIsSpawning(tag.getBoolean("IsSpawning"));
        this.campUUID = tag.contains("CampUUID") ? tag.getUUID("CampUUID") : null;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
        tag.putBoolean("IsGoingToBlowUp", this.getIsGoingToBlowUp());
        tag.putBoolean("IsSpawning", this.getIsSpawning());
        if (this.campUUID != null) {
            tag.putUUID("CampUUID", this.campUUID);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(IS_GOING_TO_BLOW_UP, (Object)false);
        builder.define(IS_SPAWNING, (Object)false);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

