/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;

public class AbstractPowderKegItem
extends Item {
    public int maxPrepareToBlowUp = this.getMaxPrepareToBlowUp();
    public float explodeRadius = this.getExplodeRadius();

    public AbstractPowderKegItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack kegItem = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide) {
            boolean b = AbstractPowderKegItem.getIsGoingToBlowUp(kegItem);
            if (!b) {
                AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, true);
            } else {
                AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
            }
        }
        return InteractionResultHolder.pass((Object)kegItem);
    }

    public void inventoryTick(ItemStack kegItem, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.isClientSide) {
            if (!pIsSelected) {
                if (AbstractPowderKegItem.getIsGoingToBlowUp(kegItem)) {
                    AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
                }
            } else {
                boolean b = AbstractPowderKegItem.getIsGoingToBlowUp(kegItem);
                int i = AbstractPowderKegItem.getPrepareToBlowUp(kegItem);
                if (b) {
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, i + 1);
                } else if (i != 0) {
                    AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
                }
                if (i >= this.maxPrepareToBlowUp) {
                    this.explodeKeg((LivingEntity)pEntity, kegItem);
                }
                if (b && i == 0) {
                    pLevel.playSound((Player)null, pEntity.getX(), pEntity.getY(), pEntity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.PLAYERS, 1.0f, 0.5f);
                }
            }
        }
        if (AbstractPowderKegItem.getIsGoingToBlowUp(kegItem)) {
            this.createFuseParticles(pLevel, pLevel.random, pEntity);
        }
        super.inventoryTick(kegItem, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void explodeKeg(LivingEntity livingEntity, ItemStack kegItem) {
        if (!livingEntity.level().isClientSide) {
            kegItem.shrink(1);
            livingEntity.level().explode((Entity)livingEntity, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), this.explodeRadius, Level.ExplosionInteraction.MOB);
            AbstractPowderKegItem.setPrepareToBlowUp(kegItem, 0);
            AbstractPowderKegItem.setIsGoingToBlowUp(kegItem, false);
            livingEntity.hurt(livingEntity.damageSources().explosion((Entity)livingEntity, (Entity)livingEntity), 50.0f);
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, Entity entity) {
        Vec3 entityPos = entity.position();
        float yaw = entity.getYRot();
        double radians = Math.toRadians(yaw);
        Vec3 bodyDirection = new Vec3(-Math.sin(radians), 0.0, Math.cos(radians)).normalize();
        double distance = 0.35;
        Vec3 particlePosition = entityPos.add(bodyDirection.scale(distance));
        double xOffset = random.nextDouble() * 0.2 - 0.1;
        double yOffset = random.nextDouble() * 0.2 - 0.1;
        double zOffset = random.nextDouble() * 0.2 - 0.1;
        double xSpeed = random.nextDouble() * 0.04 - 0.02;
        double ySpeed = random.nextDouble() * 0.06 + 0.03;
        double zSpeed = random.nextDouble() * 0.04 - 0.02;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePosition.x + xOffset, particlePosition.y + yOffset + 0.6 * (double)entity.getBbHeight(), particlePosition.z + zOffset, xSpeed, ySpeed, zSpeed);
    }

    private float getExplodeRadius() {
        return 3.0f;
    }

    private int getMaxPrepareToBlowUp() {
        return 90;
    }

    public static boolean getIsGoingToBlowUp(ItemStack kegItem) {
        if (kegItem.get(ModDataComponents.KEG_IS_GOING_TO_BLOW_UP) == null) {
            return false;
        }
        return (Boolean)kegItem.get(ModDataComponents.KEG_IS_GOING_TO_BLOW_UP);
    }

    public static void setIsGoingToBlowUp(ItemStack kegItem, boolean b) {
        kegItem.set(ModDataComponents.KEG_IS_GOING_TO_BLOW_UP, (Object)b);
    }

    public static int getPrepareToBlowUp(ItemStack kegItem) {
        if (kegItem.get(ModDataComponents.KEG_PREPARE_TO_BLOW_UP) == null) {
            return 0;
        }
        return (Integer)kegItem.get(ModDataComponents.KEG_PREPARE_TO_BLOW_UP);
    }

    public static void setPrepareToBlowUp(ItemStack kegItem, int i) {
        kegItem.set(ModDataComponents.KEG_PREPARE_TO_BLOW_UP, (Object)i);
    }
}

