/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BlunderBombEntity;

public class BlunderBombItem
extends Item
implements ProjectileItem {
    public BlunderBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (!level.isClientSide) {
            int chargeTime = this.getUseDuration(stack, livingEntity) - timeCharged;
            float chargePercent = (float)Math.min(chargeTime, 20) / 20.0f;
            if (chargeTime > 0) {
                BlunderBombEntity blunderBomb = new BlunderBombEntity(ModEntities.BLUNDER_BOMB.get(), livingEntity, level);
                float speed = 0.5f + chargePercent * 0.75f;
                blunderBomb.shootFromRotation((Entity)livingEntity, livingEntity.getXRot(), livingEntity.getYRot(), 0.0f, speed, 1.0f);
                level.addFreshEntity((Entity)blunderBomb);
                if (livingEntity instanceof Player) {
                    ((Player)livingEntity).awardStat(Stats.ITEM_USED.get((Object)this));
                    level.playSound((Player)livingEntity, ((Player)livingEntity).getOnPos(), SoundEvents.SPLASH_POTION_THROW, SoundSource.AMBIENT, 1.0f, 1.0f);
                    if (!((Player)livingEntity).isCreative()) {
                        stack.shrink(1);
                    }
                }
            }
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        System.out.println("BLUNDER BOMB FROM DISPENSER");
        BlunderBombEntity bomb = new BlunderBombEntity(level, pos.x(), pos.y(), pos.z());
        bomb.shoot(direction.getStepX(), direction.getStepY(), direction.getStepZ(), 1.0f, 1.0f);
        return bomb;
    }
}

