/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BulletEntity;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;

public class ModGunItem
extends Item {
    private final int bulletCount;
    private final int maxReloadingTime;
    public static ItemStack activeMainHandStack;
    public static ItemStack activeOffhandStack;

    public ModGunItem(Item.Properties pProperties, int bulletCount, int maxReloadingTIme) {
        super(pProperties);
        this.bulletCount = bulletCount;
        this.maxReloadingTime = maxReloadingTIme;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack gun = player.getItemInHand(usedHand);
        if (ModGunItem.getCharged(gun)) {
            Vec3 direction = Vec3.directionFromRotation((float)player.getXRot(), (float)player.getYRot());
            this.fire((LivingEntity)player, direction);
            player.playSound(SoundEvents.ARROW_SHOOT);
            ModGunItem.setCharged(gun, false);
            return InteractionResultHolder.consume((Object)gun);
        }
        player.startUsingItem(usedHand);
        ModGunItem.setCharged(gun, false);
        return InteractionResultHolder.consume((Object)gun);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int howMuchTimeItIsAlreadySet) {
        if (!level.isClientSide) {
            System.out.println("release using, timeset - " + howMuchTimeItIsAlreadySet);
            if (howMuchTimeItIsAlreadySet <= 0) {
                ModGunItem.setCharged(stack, true);
            }
        }
    }

    public boolean useOnRelease(ItemStack stack) {
        System.out.println("use one release");
        return stack.is((Item)this);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        int usingTicks;
        if (!level.isClientSide) {
            System.out.println("on use tick, remaining use duration - " + remainingUseDuration);
        }
        if ((usingTicks = this.getUseDuration(stack, livingEntity) - remainingUseDuration) >= this.getUseDuration(stack, livingEntity) && !ModGunItem.getCharged(stack)) {
            level.playSound((Player)null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
    }

    public void fire(LivingEntity shooter, Vec3 direction) {
        Level level = shooter.level();
        Vec3 origin = new Vec3(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ());
        for (int i = 0; i < this.bulletCount; ++i) {
            BulletEntity bullet = new BulletEntity(ModEntities.BULLET.get(), level);
            bullet.setOwner((Entity)shooter);
            bullet.setPos(origin);
            bullet.setVelocity(120.0f, direction);
            level.addFreshEntity((Entity)bullet);
        }
    }

    public boolean canUseFrom(LivingEntity entity, InteractionHand hand) {
        Item item;
        if (hand == InteractionHand.MAIN_HAND) {
            return true;
        }
        if (this.twoHanded()) {
            return false;
        }
        ItemStack stack = entity.getMainHandItem();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ModGunItem) {
            ModGunItem gunItem = (ModGunItem)item;
            return !gunItem.twoHanded();
        }
        return true;
    }

    public static ItemStack findAmmo(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.OFFHAND);
        if (ModGunItem.isAmmo(stack)) {
            return stack;
        }
        stack = player.getItemBySlot(EquipmentSlot.MAINHAND);
        if (ModGunItem.isAmmo(stack)) {
            return stack;
        }
        int size = player.getInventory().getContainerSize();
        for (int i = 0; i < size; ++i) {
            stack = player.getInventory().getItem(i);
            if (!ModGunItem.isAmmo(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.getItem() == ModItems.CARTRIDGE.get();
    }

    public static ItemStack getActiveStack(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return activeMainHandStack;
        }
        return activeOffhandStack;
    }

    public static void setActiveStack(InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            activeMainHandStack = stack;
        } else {
            activeOffhandStack = stack;
        }
    }

    public boolean twoHanded() {
        return false;
    }

    public static boolean getCharged(ItemStack gun) {
        Boolean charged = (Boolean)gun.get(ModDataComponents.GUN_IS_CHARGED);
        return charged != null ? charged : false;
    }

    public static void setCharged(ItemStack gun, boolean b) {
        gun.set(ModDataComponents.GUN_IS_CHARGED, (Object)b);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.maxReloadingTime;
    }
}

