/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.mrwilfis.treasures_of_the_dead.Config;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainBloomingSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainGoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.GoldenSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.ShadowSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.SkeletonCrewCamp;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.chestVariants.TreasureChestEntity;
import net.mrwilfis.treasures_of_the_dead.entity.custom.skullVariants.VillainousSkullEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.BloomingSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainBloomingSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainGoldenSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.GoldenSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.ShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.entity.variant.TOTDSkeletonVariant;

public class RandomSpawningAdventureItem
extends Item {
    private final String taskType;

    public RandomSpawningAdventureItem(Item.Properties pProperties, String taskType) {
        super(pProperties);
        this.taskType = taskType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand pUsedHand) {
        int range = Config.randomAdventureItemDistanceInChunks * 16;
        RandomSource random = level.getRandom();
        Random rand = new Random();
        double randomValue = 0.0;
        if (this.taskType.equals("random_task")) {
            randomValue = random.nextDouble();
        }
        ItemStack stack = player.getItemInHand(pUsedHand);
        double X = player.getX();
        double Y = player.getY();
        double Z = player.getZ();
        int difficulty = 0;
        if (stack.get(ModDataComponents.CAPTAIN_SKELETON_DEATH_X) != null && stack.get(ModDataComponents.CAPTAIN_SKELETON_DEATH_Z) != null) {
            X = ((Float)stack.get(ModDataComponents.CAPTAIN_SKELETON_DEATH_X)).floatValue();
            Z = ((Float)stack.get(ModDataComponents.CAPTAIN_SKELETON_DEATH_Z)).floatValue();
        }
        if (stack.getComponents().get(ModDataComponents.DIFFICULTY) != null) {
            difficulty = (Integer)stack.getComponents().get(ModDataComponents.DIFFICULTY);
        }
        X = rand.nextDouble(X - (double)range, X + (double)range);
        Z = rand.nextDouble(Z - (double)range, Z + (double)range);
        Y = level.getHeight(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
        int chunkX = (int)(X / 16.0);
        int chunkZ = (int)(Z / 16.0);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 1.0f, 1.5f);
        if (!level.isClientSide) {
            level.getChunk(chunkX, chunkZ);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            if (this.taskType.equals("treasure_map") || this.taskType.equals("random_task") && randomValue < (double)0.67f) {
                Y = level.getHeight(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
                this.summonTreasure(X, Y, Z, player, level, random);
            } else if (this.taskType.equals("skeleton_crew") || this.taskType.equals("random_task") && randomValue < 1.0) {
                BlockPos pos = new BlockPos((int)X, (int)Y, (int)Z);
                for (int i = 0; i < 100; ++i) {
                    boolean isInWater;
                    boolean bl = isInWater = level.getBlockState(pos).getBlock().equals(Blocks.WATER) || level.getBlockState(pos).getBlock().equals(Blocks.SEAGRASS) || level.getBlockState(pos).getBlock().equals(Blocks.TALL_SEAGRASS) || level.getBlockState(pos).getBlock().equals(Blocks.KELP_PLANT);
                    if (!isInWater) break;
                    X = player.getX();
                    Z = player.getZ();
                    X = rand.nextDouble(X - (double)range, X + (double)range);
                    Z = rand.nextDouble(Z - (double)range, Z + (double)range);
                    Y = level.getHeight(Heightmap.Types.OCEAN_FLOOR, (int)X, (int)Z);
                    pos = new BlockPos((int)X, (int)Y, (int)Z);
                }
                this.summonSkeletonCrewCamp(X, Y, Z, player, level, random, difficulty);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return super.use(level, player, pUsedHand);
    }

    private void summonSkeletonCrewCamp(double x, double y, double z, Player player, Level level, RandomSource random, int difficulty) {
        if (!level.isClientSide) {
            this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.skeleton_crew", "skeleton_crew");
            SkeletonCrewCamp skeletonCrewCamp = new SkeletonCrewCamp(ModEntities.SKELETON_CREW_CAMP.get(), level, difficulty, 3);
            skeletonCrewCamp.moveTo(x, y, z);
            level.addFreshEntity((Entity)skeletonCrewCamp);
        }
    }

    private void summonSkeletonCrew(double x, double y, double z, Player player, Level level, RandomSource random) {
        block8: {
            Enum variant;
            int i;
            double randomValue;
            int captainsAmount;
            Random rand;
            block11: {
                Enum variant2;
                int i2;
                block10: {
                    Enum variant3;
                    int i3;
                    block9: {
                        Enum variant4;
                        int i4;
                        if (level.isClientSide) break block8;
                        rand = new Random();
                        this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.skeleton_crew", "skeleton_crew");
                        captainsAmount = rand.nextInt(1, 4);
                        randomValue = random.nextFloat();
                        if (!(randomValue < 0.3)) break block9;
                        for (i4 = 0; i4 < captainsAmount; ++i4) {
                            CaptainSkeletonEntity captain = new CaptainSkeletonEntity(ModEntities.CAPTAIN_SKELETON.get(), level);
                            RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                            captain.setCanDropKeysAndOrders(false);
                            captain.setCustomName((Component)Component.literal((String)captain.getRandomName(random)));
                            variant4 = (CaptainSkeletonVariant)((Object)Util.getRandom((Object[])CaptainSkeletonVariant.values(), (RandomSource)random));
                            captain.setVariant((CaptainSkeletonVariant)variant4);
                            captain.populateDefaultEquipmentSlots(random);
                            y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                        }
                        for (i4 = 0; i4 < captainsAmount / 2 + 3; ++i4) {
                            TOTDSkeletonEntity pirate = new TOTDSkeletonEntity(ModEntities.TOTD_SKELETON.get(), level);
                            RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                            variant4 = (TOTDSkeletonVariant)((Object)Util.getRandom((Object[])TOTDSkeletonVariant.values(), (RandomSource)random));
                            pirate.setVariant((TOTDSkeletonVariant)variant4);
                            pirate.populateDefaultEquipmentSlots(random);
                            y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                        }
                        break block8;
                    }
                    if (!(randomValue < 0.5)) break block10;
                    for (i3 = 0; i3 < captainsAmount; ++i3) {
                        CaptainGoldenSkeletonEntity captain = new CaptainGoldenSkeletonEntity(ModEntities.CAPTAIN_GOLDEN_SKELETON.get(), level);
                        RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                        captain.setCanDropKeysAndOrders(false);
                        captain.setCustomName((Component)Component.literal((String)captain.getRandomName(random)));
                        variant3 = (CaptainGoldenSkeletonVariant)((Object)Util.getRandom((Object[])CaptainGoldenSkeletonVariant.values(), (RandomSource)random));
                        captain.setVariant((CaptainGoldenSkeletonVariant)variant3);
                        captain.populateDefaultEquipmentSlots(random);
                        y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                    }
                    for (i3 = 0; i3 < captainsAmount / 2 + 3; ++i3) {
                        GoldenSkeletonEntity pirate = new GoldenSkeletonEntity(ModEntities.GOLDEN_SKELETON.get(), level);
                        RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                        variant3 = (GoldenSkeletonVariant)((Object)Util.getRandom((Object[])GoldenSkeletonVariant.values(), (RandomSource)random));
                        pirate.setVariant((GoldenSkeletonVariant)variant3);
                        pirate.populateDefaultEquipmentSlots(random);
                        y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                    }
                    break block8;
                }
                if (!(randomValue < 0.7)) break block11;
                for (i2 = 0; i2 < captainsAmount; ++i2) {
                    CaptainShadowSkeletonEntity captain = new CaptainShadowSkeletonEntity(ModEntities.CAPTAIN_SHADOW_SKELETON.get(), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                    captain.setCanDropKeysAndOrders(false);
                    captain.setCustomName((Component)Component.literal((String)captain.getRandomName(random)));
                    variant2 = (CaptainShadowSkeletonVariant)((Object)Util.getRandom((Object[])CaptainShadowSkeletonVariant.values(), (RandomSource)random));
                    captain.setVariant((CaptainShadowSkeletonVariant)variant2);
                    captain.populateDefaultEquipmentSlots(random);
                    y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                }
                for (i2 = 0; i2 < captainsAmount / 2 + 3; ++i2) {
                    ShadowSkeletonEntity pirate = new ShadowSkeletonEntity(ModEntities.SHADOW_SKELETON.get(), level);
                    RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                    variant2 = (ShadowSkeletonVariant)((Object)Util.getRandom((Object[])ShadowSkeletonVariant.values(), (RandomSource)random));
                    pirate.setVariant((ShadowSkeletonVariant)variant2);
                    pirate.populateDefaultEquipmentSlots(random);
                    y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
                }
                break block8;
            }
            if (!(randomValue < 1.0)) break block8;
            for (i = 0; i < captainsAmount; ++i) {
                CaptainBloomingSkeletonEntity captain = new CaptainBloomingSkeletonEntity(ModEntities.CAPTAIN_BLOOMING_SKELETON.get(), level);
                RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, captain, rand);
                captain.setCanDropKeysAndOrders(false);
                captain.setCustomName((Component)Component.literal((String)captain.getRandomName(random)));
                variant = (CaptainBloomingSkeletonVariant)((Object)Util.getRandom((Object[])CaptainBloomingSkeletonVariant.values(), (RandomSource)random));
                captain.setVariant((CaptainBloomingSkeletonVariant)variant);
                captain.populateDefaultEquipmentSlots(random);
                y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
            }
            for (i = 0; i < captainsAmount / 2 + 3; ++i) {
                BloomingSkeletonEntity pirate = new BloomingSkeletonEntity(ModEntities.BLOOMING_SKELETON.get(), level);
                RandomSpawningAdventureItem.newSkeleton(x, y, z, level, random, pirate, rand);
                variant = (BloomingSkeletonVariant)((Object)Util.getRandom((Object[])BloomingSkeletonVariant.values(), (RandomSource)random));
                pirate.setVariant((BloomingSkeletonVariant)variant);
                pirate.populateDefaultEquipmentSlots(random);
                y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)(x += (double)random.nextInt(-2, 3)), (int)(z += (double)random.nextInt(-2, 3)));
            }
        }
    }

    private static void newSkeleton(double x, double y, double z, Level level, RandomSource random, TOTDSkeletonEntity skeleton, Random rand) {
        skeleton.moveTo(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
        skeleton.addTag("TOTD_Rotate");
        skeleton.setPersistenceRequired();
        level.addFreshEntity((Entity)skeleton);
        skeleton.setIsSpawning(true);
    }

    private void summonTreasure(double x, double y, double z, Player player, Level level, RandomSource random) {
        if (!level.isClientSide) {
            Random rand = new Random();
            if ((double)random.nextFloat() < (double)0.9f) {
                TreasureChestEntity treasure = new TreasureChestEntity(ModEntities.TREASURE_CHEST.get(), level);
                treasure.moveTo(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
                treasure.addTag("TOTD_Rotate");
                level.addFreshEntity((Entity)treasure);
                this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.buried_treasure", "treasure_map");
                this.buryTheTreasure((LivingEntity)treasure, level, random);
            } else if ((double)random.nextFloat() < 1.0) {
                VillainousSkullEntity treasure = new VillainousSkullEntity(ModEntities.VILLAINOUS_SKULL.get(), level);
                treasure.moveTo(x, y, z, rand.nextFloat(-180.0f, 180.0f), 0.0f);
                treasure.addTag("TOTD_Rotate");
                level.addFreshEntity((Entity)treasure);
                this.giveMap(x, y, z, player, level, random, "filled_map.treasures_of_the_dead.buried_treasure", "treasure_map");
                this.buryTheTreasure((LivingEntity)treasure, level, random);
            }
        }
    }

    private void giveMap(double x, double y, double z, Player player, Level level, RandomSource random, String mapName, String decoration) {
        if (!level.isClientSide) {
            ItemStack map = MapItem.create((Level)level, (int)((int)x), (int)((int)z), (byte)((byte)random.nextInt(0, 3)), (boolean)true, (boolean)true);
            if (decoration.equals("treasure_map")) {
                MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z), (String)"TREASURE", (Holder)MapDecorationTypes.RED_X);
            } else if (decoration.equals("skeleton_crew")) {
                MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z), (String)"TREASURE", (Holder)MapDecorationTypes.BLACK_BANNER);
            }
            map.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)mapName));
            MapItem.renderBiomePreviewMap((ServerLevel)level.getServer().overworld(), (ItemStack)map);
            if (player.getInventory().getFreeSlot() == -1) {
                ItemEntity mapEntity = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), map);
                level.addFreshEntity((Entity)mapEntity);
            } else {
                player.addItem(map);
            }
        }
    }

    private void buryTheTreasure(LivingEntity treasure, Level level, RandomSource random) {
        boolean isInAirOrInSnow;
        int x = treasure.getBlockX();
        int y = treasure.getBlockY();
        int z = treasure.getBlockZ();
        BlockPos pos1 = new BlockPos(x, y, z);
        BlockPos pos2 = new BlockPos(x, y - 1, z);
        boolean isInWater = level.getBlockState(pos1).getBlock() == Blocks.WATER;
        boolean isOnLeaves = level.getBlockState(pos2).is(BlockTags.LEAVES);
        boolean isOnAir = level.getBlockState(pos2).getBlock() == Blocks.AIR;
        boolean bl = isInAirOrInSnow = level.getBlockState(pos1).getBlock() == Blocks.AIR || level.getBlockState(pos1).getBlock() == Blocks.SNOW;
        if (isInWater) {
            treasure.moveTo((double)x, (double)y, (double)z);
        }
        while (isOnLeaves || isOnAir) {
            treasure.moveTo((double)x, (double)(y - 1), (double)z);
            y = treasure.getBlockY();
            pos1 = new BlockPos(x, y, z);
            pos2 = new BlockPos(x, y - 1, z);
            isOnLeaves = level.getBlockState(pos2).is(BlockTags.LEAVES);
            isOnAir = level.getBlockState(pos2).getBlock() == Blocks.AIR;
        }
        if (isInAirOrInSnow) {
            treasure.moveTo((double)x, (double)(y - random.nextInt(1, 4)), (double)z);
            y = treasure.getBlockY();
            pos1 = new BlockPos(x, y, z);
            pos2 = new BlockPos(x, y - 1, z);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int difficulty = 0;
        if (stack.getComponents().get(ModDataComponents.DIFFICULTY) != null) {
            difficulty = (Integer)stack.getComponents().get(ModDataComponents.DIFFICULTY);
        }
        if (this.taskType.equals("skeleton_crew")) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.treasures_of_the_dead.quest_difficulty.tooltip", (Object[])new Object[]{difficulty}));
        }
    }
}

