/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom.powderKegVariants;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.powderKegsVariants.PowderKegEntity;
import net.mrwilfis.treasures_of_the_dead.item.client.PowderKegItemRenderer;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class PowderKegItem
extends AbstractPowderKegItem
implements GeoItem {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP);
    protected static final RawAnimation FUSE = RawAnimation.begin().then("animation.model.fuse", Animation.LoopType.LOOP);

    public PowderKegItem(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getPlayer().getItemInHand(pContext.getHand());
        PowderKegEntity keg = new PowderKegEntity(ModEntities.POWDER_KEG.get(), pContext.getLevel());
        keg.addTag("TOTD_Rotate");
        if (stack.get(ModDataComponents.KEG_IS_GOING_TO_BLOW_UP) != null) {
            keg.setIsGoingToBlowUp((Boolean)stack.get(ModDataComponents.KEG_IS_GOING_TO_BLOW_UP));
        }
        if (stack.get(ModDataComponents.KEG_PREPARE_TO_BLOW_UP) != null) {
            keg.setPrepareToBlowUp((Integer)stack.get(ModDataComponents.KEG_PREPARE_TO_BLOW_UP));
        }
        BlockPos offset = pContext.getClickedPos().relative(pContext.getClickedFace(), 1);
        keg.moveTo((double)offset.getX() + 0.5, offset.getY(), (double)offset.getZ() + 0.5, 0.0f, 0.0f);
        float yaw = pContext.getPlayer().getYRot();
        if (pContext.getClickedFace() != Direction.UP) {
            yaw = pContext.getPlayer().getDirection().toYRot();
        }
        keg.setYRot(yaw - 180.0f);
        keg.yHeadRot = yaw - 180.0f;
        if (!pContext.getLevel().isClientSide) {
            pContext.getLevel().addFreshEntity((Entity)keg);
        }
        if (!pContext.getPlayer().isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PowderKegItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PowderKegItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

