/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;

public class PiratesSpawner
implements CustomSpawner {
    private int nextTick;

    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies) {
            System.out.println("NE SRABOTALO");
            return 0;
        }
        System.out.println("SRABOTALO");
        RandomSource random = level.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += 120 + random.nextInt(1);
        long days = level.getDayTime() / 24000L;
        if (days >= 5L && level.isDay()) {
            if (random.nextInt(5) == 0) {
                return 0;
            }
            int players = level.players().size();
            if (players < 1) {
                return 0;
            }
            Player player = (Player)level.players().get(random.nextInt(players));
            if (player.isSpectator()) {
                return 0;
            }
            if (level.isCloseToVillage(player.blockPosition(), 2)) {
                return 0;
            }
            int howFarX = (12 + random.nextInt(12)) * (random.nextBoolean() ? -1 : 1);
            int howFarZ = (12 + random.nextInt(12)) * (random.nextBoolean() ? -1 : 1);
            BlockPos.MutableBlockPos spawningPos = player.blockPosition().mutable().move(howFarX, 0, howFarZ);
            boolean $$10 = false;
            if (!level.hasChunksAt(spawningPos.getX() - 10, spawningPos.getZ() - 10, spawningPos.getX() + 10, spawningPos.getZ() + 10)) {
                return 0;
            }
            Holder biome = level.getBiome((BlockPos)spawningPos);
            if (!biome.is(BiomeTags.IS_BEACH)) {
                return 0;
            }
            int $$12 = 0;
            int difficulty = (int)Math.ceil(level.getCurrentDifficultyAt((BlockPos)spawningPos).getEffectiveDifficulty()) + 1;
            for (int i = 0; i < difficulty; ++i) {
                ++$$12;
                spawningPos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawningPos).getY());
                if (i == 0) {
                    if (this.spawnCrewMember(level, (BlockPos)spawningPos, random, true)) {
                        break;
                    }
                } else {
                    this.spawnCrewMember(level, (BlockPos)spawningPos, random, false);
                }
                spawningPos.setX(spawningPos.getX() + random.nextInt(-5, 6));
                spawningPos.setZ(spawningPos.getZ() + random.nextInt(-5, 6));
            }
            return $$12;
        }
        return 0;
    }

    private boolean spawnCrewMember(ServerLevel level, BlockPos pos, RandomSource random, boolean leader) {
        BlockState blockState = level.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.getFluidState(), ModEntities.TOTD_SKELETON.get())) {
            return false;
        }
        TOTDSkeletonEntity pirate = (TOTDSkeletonEntity)ModEntities.TOTD_SKELETON.get().create((Level)level);
        if (pirate != null) {
            if (leader) {
                // empty if block
            }
            pirate.setPos(pos.getX(), pos.getY(), pos.getZ());
            level.addFreshEntity((Entity)pirate);
            return true;
        }
        return false;
    }
}

