/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.atobaazul.textile.registries.TextileBlocks;
import net.atobaazul.textile.registries.TextileCreativeTabs;
import net.atobaazul.textile.registries.TextileItems;
import net.atobaazul.textile.registries.TextileLootModifiers;
import net.atobaazul.textile.registries.TextileMaterials;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@Mod(value="textile")
public class Textile {
    public static final String MOD_ID = "textile";
    public static final DataManager.Reference<ClimateRange> FLAX_CLIMATE_RANGE = Textile.registerClimateRange("crop/flax");
    public static final DataManager.Reference<ClimateRange> COTTON_CLIMATE_RANGE = Textile.registerClimateRange("crop/cotton");

    public Textile(IEventBus bus, ModContainer modContainer) {
        bus.addListener(this::commonSetup);
        TextileItems.ITEMS.register(bus);
        TextileLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(bus);
        TextileMaterials.MATERIALS.register(bus);
        TextileCreativeTabs.CREATIVE_MODE_TABS.register(bus);
        bus.addListener(this::registerColorHandler);
        TextileBlocks.BLOCKS.register(bus);
        TextileBlocks.BLOCK_ENTITIES.register(bus);
    }

    private static DataManager.Reference<ClimateRange> registerClimateRange(String name) {
        return ClimateRange.MANAGER.getReference(Textile.textileResource(name.toLowerCase(Locale.ROOT)));
    }

    public static ResourceLocation textileResource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void registerColorHandler(RegisterColorHandlersEvent.Item event) {
        ImmutableList whiteColored = ImmutableList.of(TextileItems.WOOL_SCARF, TextileItems.WOOL_GLOVES, TextileItems.SILK_SCARF, TextileItems.SILK_GLOVES, TextileItems.COTTON_SCARF, TextileItems.COTTON_GLOVES);
        TextileItems.COTTON_CLOTHES.forEach(item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), new ItemLike[]{item}));
        whiteColored.forEach(item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), new ItemLike[]{item}));
        TextileItems.LINEN_CLOTHES.forEach(item -> event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1450819), new ItemLike[]{item}));
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : -6265536, new ItemLike[]{TextileItems.LEATHER_APRON});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : -6265536, new ItemLike[]{TextileItems.LEATHER_GLOVES});
    }
}

