/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.atobaazul.textile.Textile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ScarfRenderer
implements ICurioRenderer {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(Textile.textileResource("scarf"), "scarf");
    private final HumanoidModel<LivingEntity> model;

    public ScarfRenderer(ModelPart part) {
        this.model = new HumanoidModel(part);
    }

    public static MeshDefinition mesh() {
        CubeListBuilder builder = new CubeListBuilder();
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("head", builder, PartPose.ZERO);
        return mesh;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack itemStack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int i, float v, float v1, float v2, float v3, float v4, float v5) {
        poseStack.pushPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        BakedModel scarfModel = itemRenderer.getModel(itemStack, level, entity, ScarfRenderer.getSeedForItemStack(itemStack));
        ICurioRenderer.followHeadRotations((LivingEntity)slotContext.entity(), (ModelPart[])new ModelPart[]{this.model.head});
        poseStack.translate((double)this.model.head.x / 16.0, (double)this.model.head.y / 16.0, (double)this.model.head.z / 16.0);
        poseStack.mulPose(Axis.ZP.rotation(this.model.head.zRot));
        poseStack.mulPose(Axis.YP.rotation(this.model.head.yRot));
        poseStack.mulPose(Axis.XP.rotation(this.model.head.xRot));
        itemRenderer.renderStatic(itemStack, ItemDisplayContext.HEAD, i, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, level, 0);
        poseStack.popPose();
        poseStack.pushPose();
        ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{this.model});
        poseStack.translate((double)this.model.body.x / 16.0, (double)this.model.body.y / 16.0, (double)this.model.body.z / 16.0);
        poseStack.mulPose(Axis.ZP.rotation(this.model.body.zRot));
        poseStack.mulPose(Axis.YP.rotation(0.0f));
        poseStack.mulPose(Axis.XP.rotation(0.0f));
        if (!entity.hasItemInSlot(EquipmentSlot.CHEST)) {
            itemRenderer.renderStatic(itemStack, ItemDisplayContext.NONE, i, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, level, 0);
        }
        poseStack.popPose();
    }

    private static int getSeedForItemStack(ItemStack stack) {
        return stack.isEmpty() ? 187 : Item.getId((Item)stack.getItem()) + stack.getDamageValue();
    }
}

