/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.datagen.providers;

import net.atobaazul.textile.Textile;
import net.atobaazul.textile.registries.TextileItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class TextileItemModelProvider
extends ItemModelProvider {
    private final ExistingFileHelper helper;

    public TextileItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "textile", existingFileHelper);
        this.helper = existingFileHelper;
    }

    protected void registerModels() {
        TextileItems.BLACK_BEAR_CLOTHES.forEach(this::simpleItem);
        TextileItems.CARIBOU_CLOTHES.forEach(this::simpleItem);
        TextileItems.COUGAR_CLOTHES.forEach(this::simpleItem);
        TextileItems.CROCODILE_CLOTHES.forEach(this::simpleItem);
        TextileItems.DIREWOLF_CLOTHES.forEach(this::simpleItem);
        TextileItems.GRIZZLY_BEAR_CLOTHES.forEach(this::simpleItem);
        TextileItems.LION_CLOTHES.forEach(this::simpleItem);
        TextileItems.PANTHER_CLOTHES.forEach(this::simpleItem);
        TextileItems.POLAR_BEAR_CLOTHES.forEach(this::simpleItem);
        TextileItems.RAW_HIDE_CLOTHES.forEach(this::simpleItem);
        TextileItems.SABERTOOTH_CLOTHES.forEach(this::simpleItem);
        TextileItems.TIGER_CLOTHES.forEach(this::simpleItem);
        TextileItems.BISON_CLOTHES.forEach(this::simpleItem);
        TextileItems.LINEN_CLOTHES.forEach(this::dyeableItem);
        TextileItems.COTTON_CLOTHES.forEach(this::dyeableItem);
        TextileItems.FURS.forEach(this::simpleItem);
        this.simpleItem(TextileItems.PRIMITIVE_INSULATION);
        this.simpleItem(TextileItems.COTTON_BALL);
        this.simpleItem(TextileItems.COTTON_STRING);
        this.simpleItem(TextileItems.COTTON_CLOTH);
        this.simpleItem(TextileItems.FLAX);
        this.simpleItem(TextileItems.FLAX_FIBER);
        this.simpleItem(TextileItems.LINEN_CLOTH);
    }

    private ItemModelBuilder simpleItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/generated"))).texture("layer0", Textile.textileResource("item/" + item.getId().getPath()));
    }

    private void dyeableItem(DeferredItem<Item> item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/generated"))).texture("layer0", Textile.textileResource("item/" + item.getId().getPath()))).texture("layer1", Textile.textileResource("item/" + item.getId().getPath() + "_overlay"));
    }
}

