/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.mixin;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.atobaazul.textile.common.item.TextileItemTags;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WaterTempModifier.class})
public abstract class WaterTempModifierMixin
extends TempModifier {
    @Unique
    private static final double WATER_SOAK_SPEED = 0.1;
    @Unique
    private static final double RAIN_SOAK_SPEED = 0.0125;
    @Unique
    private static final double DRY_SPEED = 0.0015;

    @Unique
    private boolean textile$isHoldingUmbrella(LivingEntity entity) {
        for (ItemStack item : entity.getHandSlots()) {
            if (!item.is(TextileItemTags.UMBRELLA)) continue;
            return true;
        }
        return false;
    }

    @Unique
    public double textile$getTemperature() {
        return this.getNBT().getDouble("Temperature");
    }

    @Unique
    public double textile$getMaxTemperature(LivingEntity entity) {
        double worldTemp = Temperature.get((LivingEntity)entity, (Temperature.Trait)Temperature.Trait.WORLD);
        double maxTemp = (Double)ConfigSettings.MAX_TEMP.get();
        double minTemp = (Double)ConfigSettings.MIN_TEMP.get();
        return CSMath.clamp((double)(Math.abs(CSMath.average((Number[])new Number[]{maxTemp, minTemp}) - worldTemp) / 2.0), (double)0.23, (double)0.5);
    }

    @Inject(method={"calculate"}, remap=false, cancellable=true, at={@At(value="HEAD")})
    private void textile$calculate(LivingEntity entity, Temperature.Trait trait, CallbackInfoReturnable<Function<Double, Double>> cir) {
        boolean isWarm = entity.isInFluidType(TFCFluids.SPRING_WATER.getType());
        double worldTemp = Temperature.get((LivingEntity)entity, (Temperature.Trait)Temperature.Trait.WORLD);
        double minWorldTemp = (Double)ConfigSettings.MIN_TEMP.get();
        double maxWorldTemp = (Double)ConfigSettings.MAX_TEMP.get();
        double configDrySpeed = (Double)ConfigSettings.DRYOFF_SPEED.get() * 0.0015;
        double temperature = this.textile$getTemperature();
        double addAmount = WorldHelper.isInWater((Entity)entity) ? 0.1 * (double)(isWarm ? 1 : -1) : (WorldHelper.isRainingAt((Level)entity.level(), (BlockPos)entity.blockPosition()) && !this.textile$isHoldingUmbrella(entity) ? 0.0125 : 0.0);
        double dryAmount = CSMath.blendExp((double)configDrySpeed, (double)(configDrySpeed * 10.0), (double)worldTemp, (double)minWorldTemp, (double)maxWorldTemp, (double)100.0);
        double maxTemp = this.textile$getMaxTemperature(entity);
        double newTemperature = CSMath.clamp((double)CSMath.shrink((double)(temperature + addAmount), (double)dryAmount), (double)(-maxTemp), (double)maxTemp);
        if (newTemperature == 0.0) {
            this.expires(0);
        }
        this.getNBT().putDouble("Temperature", newTemperature);
        if (temperature != newTemperature) {
            this.markDirty();
        }
        cir.setReturnValue(temp -> temp - newTemperature);
    }
}

