/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.registries;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.atobaazul.textile.Textile;
import net.atobaazul.textile.common.block.crop.CottonCropBlock;
import net.atobaazul.textile.common.block.crop.DeadCottonCropBlock;
import net.atobaazul.textile.common.block.crop.DeadFlaxCropBlock;
import net.atobaazul.textile.common.block.crop.FlaxCropBlock;
import net.atobaazul.textile.common.block.crop.TextileCropBlockEntity;
import net.atobaazul.textile.common.block.crop.WildCottonCropBlock;
import net.atobaazul.textile.common.block.crop.WildFlaxCropBlock;
import net.atobaazul.textile.registries.TextileItems;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TextileBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"textile");
    public static final DeferredBlock<Block> DEAD_FLAX_CROP = BLOCKS.register("dead_crop/flax", () -> new DeadFlaxCropBlock(TextileBlocks.dead(), (Supplier<ClimateRange>)Textile.FLAX_CLIMATE_RANGE));
    public static final DeferredBlock<Block> FLAX_CROP = BLOCKS.register("crop/flax", () -> new FlaxCropBlock(TextileBlocks.doubleCrop(), 2, 4, (Supplier<? extends Block>)DEAD_FLAX_CROP, (Supplier<? extends Item>)TextileItems.FLAX_SEEDS, 0.6f, 0.4f, -0.4f, (Supplier<ClimateRange>)Textile.FLAX_CLIMATE_RANGE));
    public static final DeferredBlock<Block> WILD_FLAX_CROP = BLOCKS.register("wild_crop/flax", () -> new WildFlaxCropBlock(TextileBlocks.doubleCrop()));
    public static final DeferredBlock<Block> DEAD_COTTON_CROP = BLOCKS.register("dead_crop/cotton", () -> new DeadCottonCropBlock(TextileBlocks.dead(), (Supplier<ClimateRange>)Textile.COTTON_CLIMATE_RANGE));
    public static final DeferredBlock<Block> COTTON_CROP = BLOCKS.register("crop/cotton", () -> new CottonCropBlock(TextileBlocks.doubleCrop(), 1, 5, (Supplier<? extends Block>)DEAD_COTTON_CROP, (Supplier<? extends Item>)TextileItems.COTTON_SEEDS, 0.6f, 0.4f, -0.4f, (Supplier<ClimateRange>)Textile.COTTON_CLIMATE_RANGE));
    public static final DeferredBlock<Block> WILD_COTTON_CROP = BLOCKS.register("wild_crop/cotton", () -> new WildCottonCropBlock(TextileBlocks.doubleCrop()));
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"textile");
    public static List<Supplier<Block>> cropBlocks = List.of(FLAX_CROP, WILD_FLAX_CROP, COTTON_CROP, WILD_COTTON_CROP);
    public static final Supplier<BlockEntityType<TextileCropBlockEntity>> CROP = TextileBlocks.register(BLOCK_ENTITIES, "flax", TextileCropBlockEntity::new, cropBlocks.stream());

    private static ExtendedProperties doubleCrop() {
        return TextileBlocks.dead().blockEntity(CROP).serverTicks(CropBlockEntity::serverTickBottomPartOnly);
    }

    private static ExtendedProperties crop() {
        return TextileBlocks.dead().blockEntity(CROP).serverTicks(CropBlockEntity::serverTick);
    }

    private static ExtendedProperties dead() {
        return ExtendedProperties.of((MapColor)MapColor.PLANT).noCollission().randomTicks().strength(0.4f).sound(SoundType.CROP).flammable(60, 30).pushReaction(PushReaction.DESTROY);
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.map(Supplier::get).toArray(Block[]::new))).build(null));
    }
}

