/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.registries;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.atobaazul.textile.registries.TextileBlocks;
import net.atobaazul.textile.registries.TextileMaterials;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TextileItems {
    private static final List<ArmorItem.Type> equipSlots = ImmutableList.of((Object)ArmorItem.Type.HELMET, (Object)ArmorItem.Type.CHESTPLATE, (Object)ArmorItem.Type.LEGGINGS, (Object)ArmorItem.Type.BOOTS);
    private static final Map<ArmorItem.Type, Float> durabilityMap = Map.of(ArmorItem.Type.HELMET, Float.valueOf(0.6875f), ArmorItem.Type.CHESTPLATE, Float.valueOf(1.0f), ArmorItem.Type.LEGGINGS, Float.valueOf(0.9375f), ArmorItem.Type.BOOTS, Float.valueOf(0.8125f));
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"textile");
    public static final List<DeferredItem<Item>> FURS = ImmutableList.of(TextileItems.furItem("black_bear"), TextileItems.furItem("caribou"), TextileItems.furItem("cougar"), TextileItems.basicItem("crocodile_leather"), TextileItems.furItem("direwolf"), TextileItems.furItem("grizzly_bear"), TextileItems.furItem("lion"), TextileItems.furItem("panther"), TextileItems.furItem("polar_bear"), TextileItems.furItem("sabertooth"), TextileItems.furItem("tiger"), TextileItems.furItem("bison"), (Object[])new DeferredItem[0]);
    public static final DeferredItem<Item> PRIMITIVE_INSULATION = TextileItems.basicItem("primitive_insulation");
    public static final DeferredItem<Item> COTTON_BALL = TextileItems.basicItem("cotton_ball");
    public static final DeferredItem<Item> COTTON_STRING = TextileItems.basicItem("cotton_string");
    public static final DeferredItem<Item> COTTON_CLOTH = TextileItems.basicItem("cotton_cloth");
    public static final DeferredItem<Item> FLAX = TextileItems.basicItem("flax");
    public static final DeferredItem<Item> FLAX_FIBER = TextileItems.basicItem("flax_fiber");
    public static final DeferredItem<Item> LINEN_CLOTH = TextileItems.basicItem("linen_cloth");
    public static final List<DeferredItem<Item>> BLACK_BEAR_CLOTHES = TextileItems.armorSet("black_bear", TextileMaterials.BLACK_BEAR_MATERIAL, 90);
    public static final List<DeferredItem<Item>> CARIBOU_CLOTHES = TextileItems.armorSet("caribou", TextileMaterials.CARIBOU_MATERIAL, 90);
    public static final List<DeferredItem<Item>> COUGAR_CLOTHES = TextileItems.armorSet("cougar", TextileMaterials.COUGAR_MATERIAL, 90);
    public static final List<DeferredItem<Item>> CROCODILE_CLOTHES = TextileItems.armorSet("crocodile", TextileMaterials.CROCODILE_MATERIAL, 90);
    public static final List<DeferredItem<Item>> DIREWOLF_CLOTHES = TextileItems.armorSet("direwolf", TextileMaterials.DIREWOLF_MATERIAL, 90);
    public static final List<DeferredItem<Item>> GRIZZLY_BEAR_CLOTHES = TextileItems.armorSet("grizzly_bear", TextileMaterials.GRIZZLY_BEAR_MATERIAL, 90);
    public static final List<DeferredItem<Item>> LION_CLOTHES = TextileItems.armorSet("lion", TextileMaterials.LION_MATERIAL, 90);
    public static final List<DeferredItem<Item>> PANTHER_CLOTHES = TextileItems.armorSet("panther", TextileMaterials.PANTHER_MATERIAL, 90);
    public static final List<DeferredItem<Item>> POLAR_BEAR_CLOTHES = TextileItems.armorSet("polar_bear", TextileMaterials.POLAR_BEAR_MATERIAL, 90);
    public static final List<DeferredItem<Item>> RAW_HIDE_CLOTHES = TextileItems.armorSetWithoutBoots("raw", TextileMaterials.RAW_HIDE_MATERIAL, 90);
    public static final List<DeferredItem<Item>> SABERTOOTH_CLOTHES = TextileItems.armorSet("sabertooth", TextileMaterials.SABERTOOTH_MATERIAL, 90);
    public static final List<DeferredItem<Item>> TIGER_CLOTHES = TextileItems.armorSet("tiger", TextileMaterials.TIGER_MATERIAL, 90);
    public static final List<DeferredItem<Item>> BISON_CLOTHES = TextileItems.armorSet("bison", TextileMaterials.BISON_MATERIAL, 90);
    public static final List<DeferredItem<Item>> LINEN_CLOTHES = TextileItems.armorSetWithoutBoots("linen", TextileMaterials.LINEN_MATERIAL, 50);
    public static final List<DeferredItem<Item>> COTTON_CLOTHES = TextileItems.armorSetWithoutBoots("cotton", TextileMaterials.COTTON_MATERIAL, 50);
    public static final DeferredItem<ItemNameBlockItem> FLAX_SEEDS = ITEMS.register("seeds/flax", () -> new ItemNameBlockItem((Block)TextileBlocks.FLAX_CROP.get(), new Item.Properties()));
    public static final DeferredItem<ItemNameBlockItem> COTTON_SEEDS = ITEMS.register("seeds/cotton", () -> new ItemNameBlockItem((Block)TextileBlocks.COTTON_CROP.get(), new Item.Properties()));
    public static final DeferredItem<Item> LEATHER_APRON = ITEMS.register("leather_apron", () -> new ArmorItem(TextileMaterials.LEATHER_APRON_MATERIAL, ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1).durability(60)));
    public static final DeferredItem<Item> UMBRELLA = TextileItems.basicItem("umbrella");
    public static final DeferredItem<Item> LEATHER_GLOVES = TextileItems.basicItem("leather_gloves");
    public static final DeferredItem<Item> WOOL_GLOVES = TextileItems.basicItem("wool_gloves");
    public static final DeferredItem<Item> SILK_GLOVES = TextileItems.basicItem("silk_gloves");
    public static final DeferredItem<Item> COTTON_GLOVES = TextileItems.basicItem("cotton_gloves");
    public static final DeferredItem<Item> WOOL_SCARF = TextileItems.scarfItem("wool_scarf");
    public static final DeferredItem<Item> SILK_SCARF = TextileItems.scarfItem("silk_scarf");
    public static final DeferredItem<Item> COTTON_SCARF = TextileItems.scarfItem("cotton_scarf");

    private static List<DeferredItem<Item>> armorSet(String name, Holder<ArmorMaterial> material, int baseDurability) {
        ArrayList<DeferredItem<Item>> armors = new ArrayList<DeferredItem<Item>>();
        equipSlots.forEach(slot -> armors.add(ITEMS.register(name + "_" + slot.toString().toLowerCase(), () -> new ArmorItem(material, slot, new Item.Properties().stacksTo(1).durability((int)Math.floor((float)baseDurability * durabilityMap.get(slot).floatValue()))))));
        return armors;
    }

    private static List<DeferredItem<Item>> armorSetWithoutBoots(String name, Holder<ArmorMaterial> material, int baseDurability) {
        ArrayList<DeferredItem<Item>> armors = new ArrayList<DeferredItem<Item>>();
        equipSlots.forEach(slot -> {
            if (!slot.toString().equalsIgnoreCase("boots")) {
                armors.add(ITEMS.register(name + "_" + slot.toString().toLowerCase(), () -> new ArmorItem(material, slot, new Item.Properties().stacksTo(1).durability((int)Math.floor((float)baseDurability * durabilityMap.get(slot).floatValue())))));
            }
        });
        return armors;
    }

    private static DeferredItem<Item> basicItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().stacksTo(32)));
    }

    private static DeferredItem<Item> scarfItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().stacksTo(1)));
    }

    private static DeferredItem<Item> furItem(String name) {
        return ITEMS.register(name + "_fur", () -> new Item(new Item.Properties().stacksTo(32)));
    }
}

