/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.textile.registries;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.atobaazul.textile.Textile;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TextileMaterials {
    public static final DeferredRegister<ArmorMaterial> MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"textile");
    public static final Holder<ArmorMaterial> BLACK_BEAR_MATERIAL = TextileMaterials.createFurArmorMaterial("black_bear");
    public static final Holder<ArmorMaterial> CARIBOU_MATERIAL = TextileMaterials.createFurArmorMaterial("caribou");
    public static final Holder<ArmorMaterial> COUGAR_MATERIAL = TextileMaterials.createFurArmorMaterial("cougar");
    public static final Holder<ArmorMaterial> CROCODILE_MATERIAL = TextileMaterials.createFurArmorMaterial("crocodile");
    public static final Holder<ArmorMaterial> DIREWOLF_MATERIAL = TextileMaterials.createFurArmorMaterial("direwolf");
    public static final Holder<ArmorMaterial> GRIZZLY_BEAR_MATERIAL = TextileMaterials.createFurArmorMaterial("grizzly_bear");
    public static final Holder<ArmorMaterial> LION_MATERIAL = TextileMaterials.createFurArmorMaterial("lion");
    public static final Holder<ArmorMaterial> PANTHER_MATERIAL = TextileMaterials.createFurArmorMaterial("panther");
    public static final Holder<ArmorMaterial> POLAR_BEAR_MATERIAL = TextileMaterials.createFurArmorMaterial("polar_bear");
    public static final Holder<ArmorMaterial> RAW_HIDE_MATERIAL = TextileMaterials.createFurArmorMaterial("raw_hide");
    public static final Holder<ArmorMaterial> SABERTOOTH_MATERIAL = TextileMaterials.createFurArmorMaterial("sabertooth");
    public static final Holder<ArmorMaterial> TIGER_MATERIAL = TextileMaterials.createFurArmorMaterial("tiger");
    public static final Holder<ArmorMaterial> BISON_MATERIAL = TextileMaterials.createFurArmorMaterial("bison");
    public static final Holder<ArmorMaterial> YAK_MATERIAL = TextileMaterials.createFurArmorMaterial("yak");
    public static final Holder<ArmorMaterial> LINEN_MATERIAL = TextileMaterials.createDyeableArmorMaterial("linen");
    public static final Holder<ArmorMaterial> COTTON_MATERIAL = TextileMaterials.createDyeableArmorMaterial("cotton");
    public static final Holder<ArmorMaterial> LEATHER_APRON_MATERIAL = TextileMaterials.createDyeableArmorMaterial("leather_apron");

    public static Holder<ArmorMaterial> createDyeableArmorMaterial(String name) {
        ArmorMaterial material = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, 1);
            map.put(ArmorItem.Type.CHESTPLATE, 2);
            map.put(ArmorItem.Type.LEGGINGS, 2);
            map.put(ArmorItem.Type.BOOTS, 1);
        }), 15, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(Textile.textileResource(name), "", true), new ArmorMaterial.Layer(Textile.textileResource(name), "_overlay", false)), 0.0f, 0.0f);
        return MATERIALS.register(name, () -> material);
    }

    public static Holder<ArmorMaterial> createFurArmorMaterial(String name) {
        ArmorMaterial material = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 1);
            map.put(ArmorItem.Type.LEGGINGS, 2);
            map.put(ArmorItem.Type.CHESTPLATE, 3);
            map.put(ArmorItem.Type.HELMET, 1);
            map.put(ArmorItem.Type.BODY, 4);
        }), 0, Holder.direct((Object)SoundEvents.WOOL_PLACE), () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(Textile.textileResource(name), "", true), new ArmorMaterial.Layer(Textile.textileResource(name), "", false)), 0.0f, 0.0f);
        return MATERIALS.register(name, () -> material);
    }
}

