/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.dialog;

import baguchi.bagus_lib.client.dialog.DialogEffectOption;
import baguchi.bagus_lib.client.dialog.NextDialogOption;
import baguchi.bagus_lib.register.ModDialogs;
import baguchi.bagus_lib.util.DialogHandler;
import baguchi.bagus_lib.util.client.SoundUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Matrix3x2fStack;

public class DialogType {
    public static final MapCodec<DialogType> CODEC = RecordCodecBuilder.mapCodec(p_345644_ -> p_345644_.group((App)Codec.STRING.fieldOf("dialog").forGetter(DialogType::getDialogueBase), (App)DialogEffectOption.CODEC.fieldOf("dialog_option").orElse((Object)new DialogEffectOption(1.0f, 1.0f, true, Optional.empty())).forGetter(DialogType::getDialogueOption), (App)NextDialogOption.CODEC.fieldOf("next_dialog").orElse((Object)new NextDialogOption(Optional.empty(), -1L)).forGetter(DialogType::getNextDialogOption), (App)Codec.DOUBLE.fieldOf("draw_per_tick").forGetter(DialogType::getDialogPerTick)).apply((Applicative)p_345644_, DialogType::new));
    public static final Codec<DialogType> DIRECT_CODEC = ModDialogs.getRegistry().byNameCodec().dispatch(DialogType::codec, Function.identity());
    @Nullable
    protected DialogHandler.DrawString drawingString;
    protected final String dialogueBase;
    protected final DialogEffectOption dialogueOption;
    protected final NextDialogOption nextDialogOption;
    protected long lastDialogRenderTime;
    protected final double dialogPerTick;

    public DialogType(String dialogueBase, DialogEffectOption dialogueOption, NextDialogOption nextDialogOption, double dialogPerTick) {
        this.dialogueBase = dialogueBase;
        this.dialogueOption = dialogueOption;
        this.nextDialogOption = nextDialogOption;
        this.dialogPerTick = dialogPerTick;
    }

    public MapCodec<? extends DialogType> codec() {
        return CODEC;
    }

    public void render(GuiGraphics guiGraphics, Matrix3x2fStack poseStack, float f, float tickCount, int y) {
    }

    public void renderText(GuiGraphics guiGraphics, Matrix3x2fStack poseStack, float f, float tickCount, int y) {
        Font font = Minecraft.getInstance().font;
        float g = tickCount + f;
        if (this.drawingString == null && this.dialogueBase != null) {
            MutableComponent component;
            MutableComponent mutableComponent = component = this.dialogueOption.translate() ? Component.translatable((String)this.dialogueBase) : Component.literal((String)this.dialogueBase);
            if (Minecraft.getInstance().player != null) {
                component = this.dialogueOption.translate() ? Component.translatable((String)this.dialogueBase, (Object[])new Object[]{Minecraft.getInstance().player.getName()}) : Component.literal((String)this.dialogueBase);
            }
            this.drawingString = this.beginString(guiGraphics, g, this.dialogPerTick, font, component.getString(), -1, guiGraphics.guiWidth() - 72);
        }
        if (this.drawingString != null && this.drawingString.draw(g, 72, y) && this.dialogueOption.soundEvent().isPresent()) {
            SoundUtils.playClientSound(this.dialogueOption.soundEvent().get());
        }
    }

    public DialogHandler.DrawString beginString(GuiGraphics guiGraphics, double lastTick, double perTick, Font font, String string2, int i, int j2) {
        List list = font.getSplitter().splitLines(string2, j2, Style.EMPTY);
        String string22 = list.stream().map(FormattedText::getString).collect(Collectors.joining("\n"));
        return new DialogHandler.DrawString(lastTick, perTick, string22, (string, j, k) -> {
            String[] strings = string.split("\\r?\\n");
            int l = k;
            for (String string3 : strings) {
                guiGraphics.drawString(font, string3, j, l, i);
                Objects.requireNonNull(font);
                l += 9 + 4;
            }
        });
    }

    @Nullable
    public String getDialogueBase() {
        return this.dialogueBase;
    }

    public DialogEffectOption getDialogueOption() {
        return this.dialogueOption;
    }

    public NextDialogOption getNextDialogOption() {
        return this.nextDialogOption;
    }

    protected double getDialogPerTick() {
        return this.dialogPerTick;
    }

    public void setLastDialogRenderTime(long lastDialogRenderTime) {
        this.lastDialogRenderTime = lastDialogRenderTime;
    }

    public long getLastDialogRenderTime() {
        return this.lastDialogRenderTime;
    }
}

