/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.event;

import baguchi.bagus_lib.animation.BaguAnimationController;
import baguchi.bagus_lib.api.IBagusExtraRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.InteractionHand;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.Nullable;

public abstract class BagusModelEvent
extends Event {
    private final LivingEntityRenderState entityIn;
    private final EntityModel model;

    public BagusModelEvent(LivingEntityRenderState entityIn, EntityModel model) {
        this.entityIn = entityIn;
        this.model = model;
    }

    public LivingEntityRenderState getEntityRenderState() {
        return this.entityIn;
    }

    @Nullable
    public BaguAnimationController getBaguAnimationController() {
        BaguAnimationController baguAnimationController;
        LivingEntityRenderState livingEntityRenderState = this.entityIn;
        if (livingEntityRenderState instanceof IBagusExtraRenderState) {
            IBagusExtraRenderState bagusExtraRenderState = (IBagusExtraRenderState)livingEntityRenderState;
            baguAnimationController = bagusExtraRenderState.bagusLib$getBaguAnimationController();
        } else {
            baguAnimationController = null;
        }
        return baguAnimationController;
    }

    public EntityModel getModel() {
        return this.model;
    }

    public static class FirstPersonArmAnimate
    extends BagusModelEvent {
        private final InteractionHand arm;
        private final PoseStack poseStack;

        public FirstPersonArmAnimate(LivingEntityRenderState entityIn, EntityModel model, InteractionHand arm, PoseStack poseStack) {
            super(entityIn, model);
            this.arm = arm;
            this.poseStack = poseStack;
        }

        public InteractionHand getArm() {
            return this.arm;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }

    public static class PostAnimate
    extends BagusModelEvent {
        public PostAnimate(LivingEntityRenderState entityIn, EntityModel model) {
            super(entityIn, model);
        }
    }

    public static class Scale
    extends BagusModelEvent {
        private final PoseStack poseStack;

        public Scale(LivingEntityRenderState entityIn, EntityModel model, PoseStack poseStack) {
            super(entityIn, model);
            this.poseStack = poseStack;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }
}

