/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.game;

import baguchi.bagus_lib.client.game.Fruit;
import baguchi.bagus_lib.client.game.FruitObject;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;
import org.joml.Vector2f;

public class WaterMelonCraft {
    static WaterMelonCraft instance;
    protected final RandomSource random = RandomSource.create();
    private int score;
    private float fallingX;
    private int finishTime = 0;
    private int keyCooldown;
    private static final int HEIGHT = 7;
    private static final int WIDTH = 5;
    private FruitObject tossFruit;
    private final List<FruitObject> fruitObjects = Lists.newArrayList();
    private boolean gameOver = false;
    private FruitObject nextFruit;

    public WaterMelonCraft() {
        instance = this;
        this.reset();
    }

    public void tick(Screen screen) {
        if (this.keyCooldown > 0) {
            --this.keyCooldown;
        }
        if (!this.gameOver) {
            if (this.tossFruit == null) {
                this.generateFruit();
                this.generateNextFruit();
            } else {
                float f = 0.15f;
                if (InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)264)) {
                    f = 1.0f;
                }
                if (this.keyPressed(263)) {
                    this.fallingX = this.restrictX(screen, this.fallingX - 0.5f);
                }
                if (this.keyPressed(262)) {
                    this.fallingX = this.restrictX(screen, this.fallingX + 0.5f);
                }
                if (this.keyPressed(264)) {
                    FruitObject fruitObject2 = new FruitObject(this.tossFruit.getFruit());
                    fruitObject2.setPos(new Vector2f(this.fallingX, 1.0f));
                    this.fruitObjects.add(fruitObject2);
                    this.tossFruit = null;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)1.0f, (float)0.7f));
                }
            }
            if (this.keyPressed(87)) {
                this.reset();
            }
            boolean flag2 = false;
            Set<FruitObject> fruitObjects1 = Set.copyOf(this.fruitObjects);
            Set<FruitObject> fruitObjects2 = Set.copyOf(this.fruitObjects);
            this.fruitObjects.forEach(fruitObject -> {
                boolean flag = false;
                fruitObject.tick();
                if (fruitObject.getPos().y < 0.0f) {
                    flag = true;
                }
                if (flag) {
                    ++this.finishTime;
                    if (this.finishTime >= 60) {
                        this.gameOver = true;
                    }
                } else {
                    this.finishTime = 0;
                }
            });
            for (FruitObject fruitObject3 : fruitObjects1) {
                for (FruitObject fruitObject2 : fruitObjects2) {
                    if (fruitObject3 == fruitObject2) continue;
                    int i = fruitObject3.collisionAndBig(fruitObject2, this.fruitObjects);
                    if (i > 0) {
                        flag2 = true;
                        this.score += i;
                        break;
                    }
                    fruitObject3.collisionBox(fruitObject2);
                }
                if (!flag2) continue;
                break;
            }
        }
    }

    public static WaterMelonCraft getInstance() {
        return instance;
    }

    protected Vector2f collide(Vector2f p_20273_) {
        if (p_20273_.x < 0.0f) {
            return new Vector2f(0.0f, p_20273_.y);
        }
        if (p_20273_.x > 5.0f) {
            return new Vector2f(5.0f, p_20273_.y);
        }
        if (p_20273_.y > 7.0f) {
            return new Vector2f(p_20273_.x, 7.0f);
        }
        return p_20273_;
    }

    private float restrictX(Screen screen, float xIn) {
        float scale = 5.0f;
        xIn = Mth.clamp((float)xIn, (float)0.0f, (float)scale);
        return xIn;
    }

    private boolean keyPressed(int keyId) {
        if (this.keyCooldown == 0 && InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)keyId)) {
            this.keyCooldown = 4;
            return true;
        }
        return false;
    }

    private void generateNextFruit() {
        this.nextFruit = new FruitObject(Fruit.getRandom(this.random));
    }

    private void generateFruit() {
        this.tossFruit = this.nextFruit;
    }

    private void renderFruit(GuiGraphics gui, FruitObject fruit, float x, float y, float scale, float offsetX, float offsetY) {
        this.renderBlockState(gui, fruit, offsetX + x * scale, offsetY + y * scale, scale);
    }

    private static Vector2f transform(Vector2f vector2f, float rotation, Vector2f relativeTo) {
        float i = vector2f.x;
        float k = vector2f.y;
        boolean flag = true;
        Quaternionf quaternionf = Axis.XP.rotationDegrees(rotation);
        return flag ? new Vector2f(i, k).add(quaternionf.x, quaternionf.y) : vector2f;
    }

    private void renderBlockState(GuiGraphics gui, FruitObject fruit, float offsetX, float offsetY, float size) {
        gui.pose().pushMatrix();
        TextureAtlasSprite sprite = Minecraft.getInstance().getBlockRenderer().getBlockModel(fruit.getFruit().getFruitBlock().defaultBlockState()).particleIcon();
        float f = size * fruit.getFruit().getSize();
        PoseStack stack = new PoseStack();
        stack.pushPose();
        int i = ARGB.white((float)1.0f);
        gui.pose().translate(-f / 2.0f, -f / 2.0f);
        gui.pose().translate(offsetX, offsetY);
        gui.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 0, 0, (int)(f * 2.0f), (int)(f * 2.0f), i);
        gui.pose().popMatrix();
    }

    public void render(Screen screen, GuiGraphics gui, float partialTick) {
        int i;
        float scale = Math.min((float)screen.width / 15.0f, (float)screen.height / 7.0f);
        float offsetX = (float)screen.width / 2.0f - scale * 5.0f;
        float offsetY = scale * 0.5f;
        if (this.tossFruit != null) {
            this.renderFruit(gui, this.tossFruit, this.fallingX, 0.0f, scale, offsetX, offsetY);
        }
        if (this.nextFruit != null) {
            this.renderFruit(gui, this.nextFruit, 0.0f, 0.0f, scale, (float)screen.width * 0.85f, (float)screen.height * 0.4f);
        }
        for (FruitObject fruitObject : this.fruitObjects) {
            this.renderFruit(gui, fruitObject, fruitObject.getPos().x, fruitObject.getPos().y, scale, offsetX, offsetY);
        }
        float hue = 1.0f;
        int color = i = ARGB.white((float)1.0f);
        gui.pose().pushMatrix();
        gui.pose().scale(2.0f, 2.0f);
        gui.drawCenteredString(Minecraft.getInstance().font, "Score", (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f), color);
        gui.drawCenteredString(Minecraft.getInstance().font, "" + this.score, (int)((float)screen.width * 0.065f), (int)((float)screen.height * 0.175f) + 10, color);
        gui.pose().popMatrix();
        gui.drawString(Minecraft.getInstance().font, "[LEFT ARROW] move left", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f), color);
        gui.drawString(Minecraft.getInstance().font, "[RIGHT ARROW] move right", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 10, color);
        gui.drawString(Minecraft.getInstance().font, "[DOWN ARROW] drop fruit", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 30, color);
        gui.drawString(Minecraft.getInstance().font, "[W] start over", (int)((float)screen.width * 0.71f), (int)((float)screen.height * 0.55f) + 50, color);
        if (this.gameOver) {
            gui.pose().pushMatrix();
            gui.pose().translate((float)((int)((float)screen.width * 0.5f)), (float)((int)((float)screen.height * 0.5f)));
            gui.pose().scale(3.0f, 3.0f);
            gui.drawCenteredString(Minecraft.getInstance().font, "GAME OVER", 0, 0, color);
            gui.pose().popMatrix();
        }
        if (this.finishTime > 0) {
            gui.pose().pushMatrix();
            gui.pose().translate((float)((int)((float)screen.width * 0.5f)), (float)((int)((float)screen.height * 0.5f)));
            gui.pose().scale(2.0f, 2.0f);
            gui.drawCenteredString(Minecraft.getInstance().font, "" + this.finishTime / 20, 0, 0, color);
            gui.pose().popMatrix();
        }
    }

    public void reset() {
        this.score = 0;
        this.fruitObjects.clear();
        this.gameOver = false;
        this.generateNextFruit();
        this.generateFruit();
        this.generateNextFruit();
    }
}

