/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.entity.goal;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;

public class AnimateAttackGoal
extends MeleeAttackGoal {
    protected boolean attack;
    public int attackTicks;
    protected final int actionPoint;
    protected final int attackLength;

    public AnimateAttackGoal(PathfinderMob attacker, double speed, int actionPoint, int attackLength) {
        this(attacker, speed, actionPoint, attackLength, true);
    }

    public AnimateAttackGoal(PathfinderMob attacker, double speed, int actionPoint, int attackLength, boolean longPath) {
        super(attacker, speed, longPath);
        this.actionPoint = actionPoint;
        this.attackLength = attackLength;
    }

    public void start() {
        super.start();
        this.attackTicks = 0;
    }

    public void stop() {
        super.stop();
        this.attack = false;
        this.mob.setAggressive(false);
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.isTimeToAttack()) {
            if (this.canPerformAttack(target)) {
                this.doAttack(target);
            }
        } else if (this.attackTicks >= this.attackLength) {
            this.resetAttackCooldown();
            this.attack = false;
        } else if (this.attackTicks == 0 || !this.attack) {
            if (!this.canPerformAttack(target)) {
                this.resetAttackCooldown();
            } else {
                this.attack = true;
                this.doTheAnimation();
            }
        }
        this.attackTicks = this.attack ? Mth.clamp((int)(this.attackTicks + 1), (int)0, (int)this.attackLength) : 0;
    }

    protected void doAttack(LivingEntity living) {
        Level level = this.mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.mob.doHurtTarget(serverLevel, (Entity)living);
        }
    }

    protected boolean canPerformAttack(LivingEntity target) {
        return this.mob.isWithinMeleeAttackRange(target) && this.mob.getSensing().hasLineOfSight((Entity)target);
    }

    protected void doTheAnimation() {
        this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)4);
    }

    protected void resetAttackCooldown() {
        this.attackTicks = 0;
        this.attack = false;
    }

    protected boolean isTimeToAttack() {
        return this.attackTicks == this.actionPoint;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

