/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.entity.goal;

import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class TimeConditionGoal
extends Goal {
    protected final Mob mob;
    protected int tick;
    private int cooldown;
    private int maxCooldown;
    private int maxActiveTime;
    private final UniformInt timeBetweenCooldown;
    private final UniformInt timeBetween;

    public TimeConditionGoal(Mob mob, UniformInt cooldown) {
        this(mob, cooldown, cooldown);
    }

    public TimeConditionGoal(Mob mob, UniformInt cooldown, UniformInt time) {
        this.mob = mob;
        this.timeBetweenCooldown = cooldown;
        this.timeBetween = time;
    }

    public boolean canUse() {
        if (this.maxCooldown <= 0) {
            this.maxCooldown = this.timeBetweenCooldown.sample(this.mob.getRandom());
            return false;
        }
        if (this.cooldown > this.maxCooldown) {
            this.cooldown = 0;
            this.maxCooldown = this.timeBetweenCooldown.sample(this.mob.getRandom());
            this.maxActiveTime = this.timeBetween.sample(this.mob.getRandom());
            return this.isMatchCondition();
        }
        ++this.cooldown;
        return false;
    }

    public boolean isMatchCondition() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.maxActiveTime >= this.tick;
    }

    public void tick() {
        super.tick();
        ++this.tick;
    }

    public void start() {
        super.start();
        this.tick = 0;
    }

    public void stop() {
        super.stop();
        this.tick = 0;
    }
}

