/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.animation;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.BagusLib;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;

public class BaguAnimationController<T extends Entity> {
    private final T entity;
    private final Map<ResourceLocation, AnimationState> animationStateMap = Maps.newHashMap();
    private final List<ResourceLocation> animationStateFirstPersonList = new ArrayList<ResourceLocation>();

    public BaguAnimationController(T entity) {
        this.entity = entity;
    }

    @Deprecated
    public void addAnimation(ResourceLocation resourceLocation) {
        this.animationStateMap.put(resourceLocation, new AnimationState());
    }

    @Deprecated
    public void addFirstPersonAnimation(ResourceLocation resourceLocation) {
        if (!this.animationStateFirstPersonList.contains(resourceLocation)) {
            this.animationStateFirstPersonList.add(resourceLocation);
        }
    }

    public void startAnimation(ResourceLocation resourceLocation) {
        if (this.animationStateMap.get(resourceLocation) != null) {
            this.animationStateMap.get(resourceLocation).start(((Entity)this.entity).tickCount);
        } else {
            BagusLib.LOGGER.error("Animation(" + resourceLocation.toString() + ") has not found!");
        }
    }

    public void stopAnimation(ResourceLocation resourceLocation) {
        if (this.animationStateMap.get(resourceLocation) != null) {
            this.animationStateMap.get(resourceLocation).stop();
        } else {
            BagusLib.LOGGER.error("Animation(" + resourceLocation.toString() + ") has not found!");
        }
    }

    public void stopAllAnimation() {
        this.animationStateMap.values().forEach(AnimationState::stop);
    }

    public boolean hasPlayingAnimation() {
        if (!((Boolean)BagusConfigs.COMMON.playableFirstPerson.get()).booleanValue()) {
            return false;
        }
        Optional<Map.Entry> playtest = this.animationStateMap.entrySet().stream().filter(animationStateEntry -> ((AnimationState)animationStateEntry.getValue()).isStarted() && this.animationStateFirstPersonList.contains(animationStateEntry.getKey())).findAny();
        return playtest.isPresent();
    }

    public AnimationState getAnimationState(ResourceLocation index) {
        if (this.animationStateMap.containsKey(index)) {
            return this.animationStateMap.get(index);
        }
        return new AnimationState();
    }
}

