/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.dialog;

import baguchi.bagus_lib.client.dialog.DialogEffectOption;
import baguchi.bagus_lib.client.dialog.DialogType;
import baguchi.bagus_lib.client.dialog.NextDialogOption;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2fStack;

public class ImageDialogType
extends DialogType {
    public static final MapCodec<ImageDialogType> CODEC = RecordCodecBuilder.mapCodec(p_345644_ -> p_345644_.group((App)Codec.STRING.fieldOf("dialog").forGetter(DialogType::getDialogueBase), (App)DialogEffectOption.CODEC.fieldOf("dialog_option").orElse((Object)new DialogEffectOption(1.0f, 1.0f, true, Optional.empty())).forGetter(DialogType::getDialogueOption), (App)NextDialogOption.CODEC.fieldOf("next_dialog").orElse((Object)new NextDialogOption(Optional.empty(), -1L)).forGetter(DialogType::getNextDialogOption), (App)Codec.DOUBLE.fieldOf("draw_per_tick").forGetter(DialogType::getDialogPerTick), (App)ResourceLocation.CODEC.optionalFieldOf("image").forGetter(ImageDialogType::getImage), (App)Codec.INT.fieldOf("texture_size_x").forGetter(ImageDialogType::getTextureSizeX), (App)Codec.INT.fieldOf("texture_size_y").forGetter(ImageDialogType::getTextureSizeY)).apply((Applicative)p_345644_, ImageDialogType::new));
    protected final Optional<ResourceLocation> image;
    private final int textureSizeX;
    private final int textureSizeY;

    public ImageDialogType(String dialogueBase, DialogEffectOption dialogueOption, NextDialogOption nextDialogOption, double dialogPerTick, Optional<ResourceLocation> image, int textureSizeX, int textureSizeY) {
        super(dialogueBase, dialogueOption, nextDialogOption, dialogPerTick);
        this.image = image;
        this.textureSizeX = textureSizeX;
        this.textureSizeY = textureSizeY;
    }

    @Override
    public void render(GuiGraphics guiGraphics, Matrix3x2fStack poseStack, float f, float tickCount, int y) {
        if (this.image.isPresent()) {
            poseStack.pushMatrix();
            poseStack.translate(0.0f, (float)y);
            poseStack.scale(this.dialogueOption.scaleX(), this.dialogueOption.scaleY());
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.image.get(), 0, 0, this.textureSizeX, this.textureSizeY);
            poseStack.popMatrix();
        }
    }

    @Nullable
    public Optional<ResourceLocation> getImage() {
        return this.image;
    }

    public int getTextureSizeX() {
        return this.textureSizeX;
    }

    public int getTextureSizeY() {
        return this.textureSizeY;
    }

    public MapCodec<ImageDialogType> codec() {
        return CODEC;
    }
}

