/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.game;

import baguchi.bagus_lib.client.game.Fruit;
import baguchi.bagus_lib.client.game.WaterMelonCraft;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class FruitObject {
    private Vector2f pos = new Vector2f();
    private Vector2f motion = new Vector2f();
    private float rotation;
    private float restitution = 0.5f;
    private Fruit fruit;
    private boolean isFix = false;

    public FruitObject(Fruit fruit) {
        this.fruit = fruit;
    }

    @Nonnull
    public Fruit getFruit() {
        return this.fruit;
    }

    public void setFruit(@Nonnull Fruit fruit) {
        this.fruit = fruit;
    }

    public void setPos(Vector2f pos) {
        this.pos = pos;
    }

    public void setMotion(Vector2f motion) {
        this.motion = motion;
    }

    public Vector2f getMotion() {
        return this.motion;
    }

    public Vector2f getPos() {
        return this.pos;
    }

    public void collisionBox(FruitObject fruitObject) {
        Vector2f reflect;
        Vector2f moveDirection;
        float dist = this.pos.distance(fruitObject.pos.x, fruitObject.pos.y);
        if (dist > this.fruit.getSize() + fruitObject.fruit.getSize()) {
            return;
        }
        float overlap = this.fruit.getSize() + fruitObject.fruit.getSize() - dist;
        Vector2f center2Center = new Vector2f(this.pos.x - fruitObject.pos.x, this.pos.y - fruitObject.pos.y);
        float returnDist = overlap;
        if (!this.isFix) {
            returnDist = overlap / 2.0f;
            moveDirection = this.unit(new Vector2f((Vector2fc)center2Center)).mul(-1.0f);
            fruitObject.move(moveDirection.x * returnDist, moveDirection.y * returnDist);
            reflect = this.reflect(fruitObject.motion, new Vector2f((Vector2fc)center2Center)).mul(this.restitution);
            fruitObject.move(reflect.x, reflect.y);
        }
        moveDirection = this.unit(new Vector2f((Vector2fc)center2Center));
        this.move(moveDirection.x * returnDist, moveDirection.y * returnDist);
        reflect = this.reflect(fruitObject.motion, new Vector2f((Vector2fc)center2Center)).mul(this.restitution);
        this.move(reflect.x, reflect.y);
    }

    public Vector2f reflect(Vector2f vec2, Vector2f vec21) {
        Vector2f normUnit = this.unit(vec21);
        float dot = vec2.dot((Vector2fc)normUnit);
        if (dot == 0.0f) {
            return vec2.mul(-1.0f);
        }
        Vector2f ref_vec = normUnit.mul(-2.0f * dot);
        return vec2.add(ref_vec.x, ref_vec.y);
    }

    public Vector2f unit(Vector2f vec2) {
        return vec2.mul(1.0f / vec2.length());
    }

    public Vector2f move(float dx, float dy) {
        float new_x = this.pos.x + dx;
        float new_y = this.pos.y + dy;
        this.pos = WaterMelonCraft.getInstance().collide(new Vector2f(new_x, new_y));
        return this.pos;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void tick() {
        this.motion.mul(0.96f);
        this.motion.y += 0.01f;
        this.move(this.motion.x, this.motion.y);
    }

    public int collisionAndBig(FruitObject fruitObject, List<FruitObject> fruitObjects) {
        float dist = this.pos.distance(fruitObject.pos.x, fruitObject.pos.y);
        if (dist > this.fruit.getSize() + fruitObject.fruit.getSize()) {
            return 0;
        }
        if (this.fruit == fruitObject.getFruit()) {
            Fruit fruit1 = Fruit.getNextObject(fruitObject.getFruit());
            if (fruit1 != null) {
                Vector2f newPos = this.pos.add(fruitObject.pos.x, fruitObject.pos.y).mul(0.5f);
                FruitObject fruitObject1 = new FruitObject(fruit1);
                fruitObject1.warp(newPos);
                fruitObjects.add(fruitObject1);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CAT_EAT, (float)1.0f, (float)1.0f));
            }
            fruitObjects.remove(this);
            fruitObjects.remove(fruitObject);
            return this.fruit.getScore();
        }
        return 0;
    }

    public FruitObject warp(Vector2f vec2) {
        this.pos = vec2;
        return this;
    }
}

