/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.aepherastudios.createdefensive.effect.ModEffects;
import net.aepherastudios.createdefensive.item.ModArmorMaterials;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModArmorItem
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.SILVER, (Object)new MobEffectInstance((MobEffect)ModEffects.SILVER_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.PLATINUM, (Object)new MobEffectInstance((MobEffect)ModEffects.PLATINUM_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.ELECTRUM, (Object)new MobEffectInstance((MobEffect)ModEffects.ELECTRUM_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.REDSTONE, (Object)new MobEffectInstance((MobEffect)ModEffects.REDSTONE_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.ROSE_GOLD, (Object)new MobEffectInstance((MobEffect)ModEffects.UNSTABLE_ROSE_GOLD_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.ROSE_GOLD_CEREMONIAL, (Object)new MobEffectInstance((MobEffect)ModEffects.ROSE_GOLD_ARMOR.get(), 600, 1, false, false, true)).put((Object)ModArmorMaterials.VIOLET_GOLD_CEREMONIAL, (Object)new MobEffectInstance((MobEffect)ModEffects.VIOLET_GOLD_ARMOR.get(), 600, 1, false, false, true)).put((Object)ModArmorMaterials.GOLD_CEREMONIAL, (Object)new MobEffectInstance((MobEffect)ModEffects.GOLD_ARMOR.get(), 600, 0, false, false, true)).put((Object)ModArmorMaterials.STEEL, (Object)new MobEffectInstance((MobEffect)ModEffects.STEEL_ARMOR.get(), 600, 0, false, false, true)).build();

    public ModArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }
}

