/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.block.entity;

import javax.annotation.Nullable;
import net.aepherastudios.createdefensive.block.custom.IndustrialHeaterBlock;
import net.aepherastudios.createdefensive.block.entity.DefensiveBlockEntities;
import net.aepherastudios.createdefensive.screen.IndustrialHeaterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class IndustrialHeaterBlockEntity
extends BlockEntity
implements MenuProvider {
    public int burnTime = 0;
    public int totalBurnTime = 0;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ItemStackHandler handler = new ItemStackHandler(1);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IndustrialHeaterBlockEntity.this.m_6596_();
        }
    };
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> IndustrialHeaterBlockEntity.this.burnTime;
                case 1 -> IndustrialHeaterBlockEntity.this.totalBurnTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IndustrialHeaterBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    IndustrialHeaterBlockEntity.this.totalBurnTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public IndustrialHeaterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DefensiveBlockEntities.INDUSTRIAL_HEATER.get(), pos, state);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, IndustrialHeaterBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean wasLit = (Boolean)state.m_61143_((Property)IndustrialHeaterBlock.LIT);
        boolean isLit = false;
        ItemStackHandler inventory = blockEntity.itemHandler;
        ItemStack fuelStack = inventory.getStackInSlot(0);
        if (blockEntity.burnTime > 0) {
            --blockEntity.burnTime;
            isLit = true;
        } else if (!fuelStack.m_41619_() && ForgeHooks.getBurnTime((ItemStack)fuelStack, null) > 0) {
            blockEntity.totalBurnTime = blockEntity.burnTime = ForgeHooks.getBurnTime((ItemStack)fuelStack, null);
            fuelStack.m_41774_(1);
            blockEntity.m_6596_();
            isLit = true;
        }
        if (wasLit != isLit) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IndustrialHeaterBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
        }
        if (isLit) {
            // empty if block
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new IndustrialHeaterMenu(windowId, playerInventory, this, this.data);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.createdefensive.industrial_heater");
    }

    private void setLitState(boolean lit) {
        if (this.f_58857_ != null && (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)IndustrialHeaterBlock.LIT) != lit) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)IndustrialHeaterBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }
}

