/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.event;

import net.aepherastudios.createdefensive.effect.DefensiveEffects;
import net.aepherastudios.createdefensive.item.custom.GreatswordItem;
import net.aepherastudios.createdefensive.item.custom.HammerItem;
import net.aepherastudios.createdefensive.item.custom.StaffItem;
import net.aepherastudios.createdefensive.item.custom.ZweihanderItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DefensiveCommonEvents {
    private static boolean isFireDamage(String type) {
        return type.equals("in_fire") || type.equals("on_fire") || type.equals("lava") || type.equals("hot_floor") || type.equals("fireball");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            String damageType;
            LivingEntity victim = event.getEntity();
            Entity aggressor = event.getSource().m_7639_();
            float adjustedDamage = event.getAmount();
            if (aggressor != null) {
                double dz;
                double dx = victim.m_20185_() - aggressor.m_20185_();
                double distance = Math.sqrt(dx * dx + (dz = victim.m_20189_() - aggressor.m_20189_()) * dz);
                if (distance < 0.001) {
                    distance = 0.001;
                }
                if (!(aggressor instanceof LivingEntity)) {
                    return;
                }
                LivingEntity attacker = (LivingEntity)aggressor;
                if (aggressor instanceof LivingEntity) {
                    ItemStack weapon = attacker.m_21120_(InteractionHand.MAIN_HAND);
                    if (weapon.m_41720_() instanceof GreatswordItem || weapon.m_41720_() instanceof HammerItem) {
                        double strength = 2.0;
                        victim.m_5997_(dx / distance * strength, 0.1, dz / distance * strength);
                        victim.f_19864_ = true;
                    }
                    if (weapon.m_41720_() instanceof StaffItem) {
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 200, 0), (Entity)attacker);
                        attacker.m_147207_(new MobEffectInstance(MobEffects.f_19603_, 200, 1), (Entity)attacker);
                    }
                    if (weapon.m_41720_() instanceof ZweihanderItem) {
                        float originalDamage = event.getAmount();
                        int armorValue = victim.m_21230_();
                        float armorReduction = (float)armorValue * 0.04f;
                        float ignored = armorReduction * 0.5f;
                        adjustedDamage = originalDamage / (1.0f - (armorReduction - ignored));
                    }
                }
            }
            if (victim.m_21023_((MobEffect)DefensiveEffects.TARRED.get()) && DefensiveCommonEvents.isFireDamage(damageType = event.getSource().m_19385_())) {
                float original = event.getAmount();
                event.setAmount(original * 2.0f);
            }
            event.setAmount(adjustedDamage);
        }
    }
}

